/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.plugin.mp;

import eu.maveniverse.maven.toolbox.plugin.MPPluginMojoSupport;
import eu.maveniverse.maven.toolbox.shared.ResolutionRoot;
import eu.maveniverse.maven.toolbox.shared.ResolutionScope;
import eu.maveniverse.maven.toolbox.shared.Result;
import eu.maveniverse.maven.toolbox.shared.ToolboxCommando;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="plugin-tree-find", threadSafe=true)
public class PluginTreeFindMojo
extends MPPluginMojoSupport {
    @Parameter(property="scope", defaultValue="runtime", required=true)
    private String scope;
    @Parameter(property="artifactMatcherSpec", required=true)
    private String artifactMatcherSpec;
    @Parameter(property="verboseTree", defaultValue="false", required=true)
    private boolean verboseTree;

    protected Result<Boolean> doExecute() throws Exception {
        ToolboxCommando toolboxCommando = this.getToolboxCommando();
        ResolutionRoot root = this.pluginAsResolutionRoot(toolboxCommando, false);
        if (root != null) {
            this.getOutput().doTell("Paths found in plugin {}", new Object[]{root.getArtifact()});
            toolboxCommando.treeFind(ResolutionScope.parse((String)this.scope), root, this.verboseTree, toolboxCommando.parseArtifactMatcherSpec(this.artifactMatcherSpec));
        } else {
            for (ResolutionRoot resolutionRoot : this.allProjectPluginsAsResolutionRoots(toolboxCommando)) {
                this.getOutput().doTell("Paths found in plugin {}", new Object[]{resolutionRoot.getArtifact()});
                toolboxCommando.treeFind(ResolutionScope.parse((String)this.scope), resolutionRoot, this.verboseTree, toolboxCommando.parseArtifactMatcherSpec(this.artifactMatcherSpec));
            }
        }
        return Result.success((Object)true);
    }
}

