/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.plugin.mp;

import eu.maveniverse.maven.toolbox.plugin.MPPluginMojoSupport;
import eu.maveniverse.maven.toolbox.shared.ArtifactMatcher;
import eu.maveniverse.maven.toolbox.shared.ArtifactVersionMatcher;
import eu.maveniverse.maven.toolbox.shared.ArtifactVersionSelector;
import eu.maveniverse.maven.toolbox.shared.ResolutionRoot;
import eu.maveniverse.maven.toolbox.shared.ResolutionScope;
import eu.maveniverse.maven.toolbox.shared.Result;
import eu.maveniverse.maven.toolbox.shared.ToolboxCommando;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="plugin-libyear", threadSafe=true)
public class PluginLibYearMojo
extends MPPluginMojoSupport {
    @Parameter(property="artifactMatcherSpec", defaultValue="any()")
    private String artifactMatcherSpec;
    @Parameter(property="artifactVersionMatcherSpec", defaultValue="noSnapshotsAndPreviews()")
    private String artifactVersionMatcherSpec;
    @Parameter(property="artifactVersionSelectorSpec", defaultValue="major()")
    private String artifactVersionSelectorSpec;
    @Parameter(property="transitive", defaultValue="false")
    private boolean transitive;
    @Parameter(property="upToDate", defaultValue="false")
    private boolean upToDate;

    protected Result<String> doExecute() throws Exception {
        ToolboxCommando toolboxCommando = this.getToolboxCommando();
        ArtifactMatcher artifactMatcher = toolboxCommando.parseArtifactMatcherSpec(this.artifactMatcherSpec);
        ArtifactVersionMatcher artifactVersionMatcher = toolboxCommando.parseArtifactVersionMatcherSpec(this.artifactVersionMatcherSpec);
        ArtifactVersionSelector artifactVersionSelector = toolboxCommando.parseArtifactVersionSelectorSpec(this.artifactVersionSelectorSpec);
        for (ResolutionRoot root : this.allProjectManagedPluginsAsResolutionRoots(toolboxCommando).stream().filter(r -> artifactMatcher.test((Object)r.getArtifact())).toList()) {
            toolboxCommando.libYear("managed plugin " + String.valueOf(root.getArtifact()), ResolutionScope.RUNTIME, root, this.transitive, this.upToDate, (Predicate)artifactVersionMatcher, (BiFunction)artifactVersionSelector, this.getRepositoryVendor());
        }
        for (ResolutionRoot root : this.allProjectPluginsAsResolutionRoots(toolboxCommando).stream().filter(r -> artifactMatcher.test((Object)r.getArtifact())).toList()) {
            toolboxCommando.libYear("plugin " + String.valueOf(root.getArtifact()), ResolutionScope.RUNTIME, root, this.transitive, this.upToDate, (Predicate)artifactVersionMatcher, (BiFunction)artifactVersionSelector, this.getRepositoryVendor());
        }
        return Result.success((Object)"Success");
    }
}

