/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.plugin.gav;

import eu.maveniverse.maven.toolbox.plugin.GavMojoSupport;
import eu.maveniverse.maven.toolbox.shared.Result;
import eu.maveniverse.maven.toolbox.shared.Source;
import eu.maveniverse.maven.toolbox.shared.ToolboxCommando;
import java.io.File;
import java.util.List;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.artifact.Artifact;
import picocli.CommandLine;

@CommandLine.Command(name="deploy", description={"Deploys Maven Artifact into remote repository"})
@Mojo(name="gav-deploy", requiresProject=false, threadSafe=true)
public final class GavDeployMojo
extends GavMojoSupport {
    @CommandLine.Parameters(index="0", description={"The remote repository spec (id::url)"}, arity="1")
    @Parameter(property="remoteRepositorySpec", required=true)
    private String remoteRepositorySpec;
    @CommandLine.Parameters(index="1", description={"The GAV to deploy to"}, arity="1")
    @Parameter(property="gav", required=true)
    private String gav;
    @CommandLine.Parameters(index="2", description={"The artifact JAR file"}, arity="1")
    @Parameter(property="jar", required=true)
    private File jar;
    @CommandLine.Option(names={"--pom"}, description={"The POM file"})
    @Parameter(property="pom")
    private File pom;
    @CommandLine.Option(names={"--sources"}, description={"The sources JAR file"})
    @Parameter(property="sources")
    private File sources;
    @CommandLine.Option(names={"--javadoc"}, description={"The javadoc JAR file"})
    @Parameter(property="javadoc")
    private File javadoc;

    protected Result<List<Artifact>> doExecute() throws Exception {
        ToolboxCommando toolboxCommando = this.getToolboxCommando();
        return toolboxCommando.copy((Source)this.projectArtifacts(this.gav, this.jar, this.pom, this.sources, this.javadoc), toolboxCommando.artifactSink("deploy(" + this.remoteRepositorySpec + ")"));
    }
}

