/*
 * Decompiled with CFR 0.152.
 */
package eu.markov.jenkins.plugin.mvnmeta;

import hudson.EnvVars;
import hudson.model.AbstractBuild;
import hudson.model.ParameterValue;
import hudson.model.Run;
import hudson.util.VariableResolver;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.export.Exported;

public class MavenMetadataParameterValue
extends ParameterValue {
    private static final long serialVersionUID = -7853796229856029964L;
    public static final String GROUP_ID_SUFFIX = "_GROUP_ID";
    public static final String ARTIFACT_ID_SUFFIX = "_ARTIFACT_ID";
    public static final String VERSION_SUFFIX = "_VERSION";
    public static final String PACKAGING_SUFFIX = "_PACKAGING";
    public static final String CLASSIFIER_SUFFIX = "_CLASSIFIER";
    public static final String ARTIFACT_URL_SUFFIX = "_ARTIFACT_URL";
    @Exported
    private final String groupId;
    @Exported
    private final String artifactId;
    @Exported
    private final String version;
    @Exported
    private final String packaging;
    @Exported
    private final String classifier;
    @Exported
    private String artifactUrl;

    @DataBoundConstructor
    public MavenMetadataParameterValue(String name, String description, String groupId, String artifactId, String version, String packaging, String classifier, String artifactUrl) {
        super(name, description);
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.packaging = packaging;
        this.classifier = classifier;
        this.artifactUrl = artifactUrl;
    }

    public Object getValue() {
        return this.getVersion();
    }

    public void buildEnvironment(Run<?, ?> build, EnvVars env) {
        env.put(this.getName() + GROUP_ID_SUFFIX, this.getGroupId());
        env.put(this.getName() + ARTIFACT_ID_SUFFIX, this.getArtifactId());
        env.put(this.getName() + VERSION_SUFFIX, this.getVersion());
        env.put(this.getName() + ARTIFACT_URL_SUFFIX, this.getArtifactUrl());
        env.put(this.getName() + PACKAGING_SUFFIX, this.getPackaging());
        env.put(this.getName() + CLASSIFIER_SUFFIX, this.getClassifier());
    }

    public VariableResolver<String> createVariableResolver(AbstractBuild<?, ?> build) {
        return new VariableResolver<String>(){

            public String resolve(String name) {
                if (StringUtils.isNotBlank((String)name)) {
                    if (name.equals(MavenMetadataParameterValue.this.getName() + MavenMetadataParameterValue.GROUP_ID_SUFFIX)) {
                        return MavenMetadataParameterValue.this.getGroupId();
                    }
                    if (name.equals(MavenMetadataParameterValue.this.getName() + MavenMetadataParameterValue.ARTIFACT_ID_SUFFIX)) {
                        return MavenMetadataParameterValue.this.getArtifactId();
                    }
                    if (name.equals(MavenMetadataParameterValue.this.getName() + MavenMetadataParameterValue.VERSION_SUFFIX)) {
                        return MavenMetadataParameterValue.this.getVersion();
                    }
                    if (name.equals(MavenMetadataParameterValue.this.getName() + MavenMetadataParameterValue.ARTIFACT_URL_SUFFIX)) {
                        return MavenMetadataParameterValue.this.getArtifactUrl();
                    }
                    if (name.equals(MavenMetadataParameterValue.this.getName() + MavenMetadataParameterValue.PACKAGING_SUFFIX)) {
                        return MavenMetadataParameterValue.this.getPackaging();
                    }
                    if (name.equals(MavenMetadataParameterValue.this.getName() + MavenMetadataParameterValue.CLASSIFIER_SUFFIX)) {
                        return MavenMetadataParameterValue.this.getClassifier();
                    }
                }
                return null;
            }
        };
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getArtifactUrl() {
        return this.artifactUrl;
    }

    public void setArtifactUrl(String artifactUrl) {
        this.artifactUrl = artifactUrl;
    }

    public String toString() {
        return "MavenMetadataParameterValue(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ", packaging=" + this.getPackaging() + ", classifier=" + this.getClassifier() + ", artifactUrl=" + this.getArtifactUrl() + ")";
    }
}

