/*
 * Decompiled with CFR 0.152.
 */
package eu.lundegaard.commons.util;

import java.util.Collection;
import java.util.Map;

public final class ValidateUtil {
    private ValidateUtil() {
    }

    public static void validateNotNull(Object object) {
        ValidateUtil.validateNotNull(object, "Object must not be null.");
    }

    public static void validateNotNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void validateNotEmpty(Object[] array) {
        ValidateUtil.validateNotEmpty(array, "Array must not be empty.");
    }

    public static void validateNotEmpty(Object[] array, String message) {
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void validateNotEmpty(Collection collection) {
        ValidateUtil.validateNotEmpty(collection, "Collection must not be empty.");
    }

    public static void validateNotEmpty(Collection collection, String message) {
        if (collection == null || collection.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void validateNotEmpty(Map map) {
        ValidateUtil.validateNotEmpty(map, "Map must not be empty.");
    }

    public static void validateNotEmpty(Map map, String message) {
        if (map == null || map.size() == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void validateNotEmpty(String string) {
        ValidateUtil.validateNotEmpty(string, "String value must not be empty.");
    }

    public static void validateNotEmpty(String string, String message) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException(message);
        }
    }
}

