/*
 * Decompiled with CFR 0.152.
 */
package eu.lundegaard.commons.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class UrlUtil {
    private UrlUtil() {
    }

    public static Map<String, List<String>> getUrlQueryParameters(String url) {
        URI uri;
        if (url == null) {
            return Collections.emptyMap();
        }
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            return Collections.emptyMap();
        }
        return UrlUtil.parseUrlQueryParameters(uri.getRawQuery());
    }

    public static Map<String, List<String>> parseUrlQueryParameters(String urlQuery) {
        if (urlQuery != null && !urlQuery.isEmpty()) {
            return Arrays.stream(urlQuery.split("&")).map(UrlUtil::splitStringToMapEntry).filter(Optional::isPresent).map(Optional::get).collect(Collectors.groupingBy(Map.Entry::getKey, LinkedHashMap::new, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
        }
        return Collections.emptyMap();
    }

    private static Optional<Map.Entry<String, String>> splitStringToMapEntry(String str) {
        String[] splitString = str.split("=", 2);
        if (splitString.length != 2) {
            return Optional.empty();
        }
        return Optional.of(new AbstractMap.SimpleEntry<String, String>(splitString[0], splitString[1]));
    }
}

