/*
 * Decompiled with CFR 0.152.
 */
package eu.lundegaard.commons.util;

import eu.lundegaard.commons.util.ValidateUtil;
import java.text.Normalizer;

public final class StringUtil {
    private StringUtil() {
    }

    public static String getSafeFilename(String input) {
        ValidateUtil.validateNotNull(input);
        String s = input;
        s = StringUtil.removeDiacriticalMarks(s);
        s = StringUtil.replaceFilenameUnsafeChars(s, "_");
        return s;
    }

    public static String removeDiacriticalMarks(String input) {
        ValidateUtil.validateNotNull(input);
        return Normalizer.normalize(input, Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
    }

    public static String replaceFilenameUnsafeChars(String input, String replacement) {
        ValidateUtil.validateNotNull(input);
        ValidateUtil.validateNotNull(replacement);
        return input.replaceAll("[^a-zA-Z0-9 \\(\\)_\\+\\[\\]\\.-]", replacement);
    }

    public static String removeMultipleOccurrencesOfChar(String input, char character) {
        String pattern = "[" + character + "]{2,}";
        String replacement = String.valueOf(character);
        return input.replaceAll(pattern, replacement);
    }

    public static boolean startsWithIgnoreCase(String haystack, String prefix) {
        ValidateUtil.validateNotNull(haystack);
        ValidateUtil.validateNotNull(prefix);
        if (haystack.length() < prefix.length()) {
            return false;
        }
        String hayPrefix = haystack.substring(0, prefix.length());
        return hayPrefix.equalsIgnoreCase(prefix);
    }
}

