/*
 * Decompiled with CFR 0.152.
 */
package eu.lundegaard.commons.util;

import eu.lundegaard.commons.iface.Identifiable;
import eu.lundegaard.commons.util.ValidateUtil;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public final class ConversionUtil {
    private ConversionUtil() {
    }

    public static List<Long> toLongs(List<Object> inputList) {
        ValidateUtil.validateNotNull(inputList);
        return inputList.stream().map(ConversionUtil::toLongOrNull).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static Long toLong(Object input) {
        Optional<Long> result = Optional.ofNullable(ConversionUtil.toLongOrNull(input));
        return result.orElseThrow(() -> new NumberFormatException("Cannot convert " + input + " to long."));
    }

    private static Long toLongOrNull(Object input) {
        if (input == null) {
            return null;
        }
        if (input instanceof Number) {
            return ((Number)input).longValue();
        }
        if (input instanceof String) {
            return ConversionUtil.stringToLongOrNull((String)input);
        }
        if (input instanceof Identifiable) {
            Object id = ((Identifiable)input).getId();
            return ConversionUtil.toLongOrNull(id);
        }
        return null;
    }

    private static Long stringToLongOrNull(String input) {
        try {
            return Long.parseLong(input);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

