/*
 * Decompiled with CFR 0.152.
 */
package eu.lundegaard.commons.tuple;

import java.util.Objects;

public class Triple<T, U, V> {
    private T first;
    private U second;
    private V third;

    public Triple(T first, U second, V third) {
        if (first == null || second == null || third == null) {
            throw new IllegalArgumentException("Values of must not be null.");
        }
        this.first = first;
        this.second = second;
        this.third = third;
    }

    public T getFirst() {
        return this.first;
    }

    public Triple<T, U, V> withFirst(T newFirst) {
        return new Triple<T, U, V>(newFirst, this.second, this.third);
    }

    public U getSecond() {
        return this.second;
    }

    public Triple<T, U, V> withSecond(U newSecond) {
        return new Triple<T, U, V>(this.first, newSecond, this.third);
    }

    public V getThird() {
        return this.third;
    }

    public Triple<T, U, V> withThird(V newThird) {
        return new Triple<T, U, V>(this.first, this.second, newThird);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Triple triple = (Triple)o;
        if (!this.first.equals(triple.first)) {
            return false;
        }
        if (!this.second.equals(triple.second)) {
            return false;
        }
        return this.third.equals(triple.third);
    }

    public int hashCode() {
        return Objects.hash(this.first, this.second, this.third);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.first + "," + this.second + "," + this.third + "}";
    }
}

