/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.robotools.os;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.View;
import android.view.inputmethod.InputMethodManager;

public class RTKeyboard {
    private RTKeyboard() {
    }

    public static void hideKeyboard(Activity ctx) {
        if (ctx != null) {
            InputMethodManager inputManager = (InputMethodManager)ctx.getSystemService("input_method");
            if (ctx.getCurrentFocus() != null) {
                inputManager.hideSoftInputFromWindow(ctx.getCurrentFocus().getWindowToken(), 2);
            }
        }
    }

    public static void hideKeyboard(View view) {
        InputMethodManager inputManager = (InputMethodManager)view.getContext().getSystemService("input_method");
        inputManager.hideSoftInputFromWindow(view.getWindowToken(), 2);
    }

    public static void showKeyboard(Activity ctx) {
        InputMethodManager inputManager = (InputMethodManager)ctx.getSystemService("input_method");
        if (ctx.getCurrentFocus() != null) {
            inputManager.showSoftInput(ctx.getCurrentFocus(), 1);
        }
    }

    public static void showKeyboard(final View view, long delay) {
        new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

            @Override
            public void run() {
                RTKeyboard.showKeyboard(view);
            }
        }, delay);
    }

    public static void showKeyboard(View view) {
        InputMethodManager inputManager = (InputMethodManager)view.getContext().getSystemService("input_method");
        view.requestFocus();
        inputManager.showSoftInput(view, 1);
    }

    public static void showSoftKeyboardFor(Context ctx, View view) {
        try {
            InputMethodManager mgr = (InputMethodManager)ctx.getSystemService("input_method");
            if (view != null) {
                view.requestFocus();
                mgr.showSoftInput(view, 2);
            } else {
                mgr.toggleSoftInput(2, 0);
            }
        }
        catch (Throwable err) {
            Log.e((String)RTKeyboard.class.getName(), (String)err.getMessage(), (Throwable)err);
        }
    }

    public static void hideSoftKeyboardFor(Activity activity, View view) {
        if (view != null) {
            try {
                InputMethodManager mgr = (InputMethodManager)activity.getSystemService("input_method");
                mgr.hideSoftInputFromWindow(view.getWindowToken(), 0);
            }
            catch (Throwable err) {
                Log.e((String)RTKeyboard.class.getName(), (String)err.getMessage(), (Throwable)err);
            }
        } else {
            try {
                InputMethodManager mgr = (InputMethodManager)activity.getSystemService("input_method");
                activity.getWindow().setSoftInputMode(3);
                mgr.hideSoftInputFromWindow(activity.findViewById(0x1020002).getWindowToken(), 0);
                mgr.hideSoftInputFromWindow(activity.findViewById(0x1020002).getApplicationWindowToken(), 0);
            }
            catch (Throwable err) {
                Log.e((String)RTKeyboard.class.getName(), (String)err.getMessage(), (Throwable)err);
            }
        }
    }
}

