/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.robotools.share;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.provider.ContactsContract;
import android.telephony.PhoneNumberUtils;
import android.text.TextUtils;

public class RTShareTool {
    public static Intent buildCallIntent(String number) {
        Intent callIntent = new Intent("android.intent.action.CALL");
        callIntent.setData(Uri.parse((String)(number.toLowerCase().startsWith("tel:") ? number : String.format("tel:%s", PhoneNumberUtils.stripSeparators((String)number)))));
        return callIntent;
    }

    public static Intent buildInternetAddressIntent(String url) {
        return new Intent("android.intent.action.VIEW").setData(Uri.parse((String)url));
    }

    public static Intent buildEmailIntent(String to, String subject, String body) {
        Intent emailIntent = new Intent("android.intent.action.SEND");
        emailIntent.setType("plain/text");
        emailIntent.putExtra("android.intent.extra.EMAIL", new String[]{to});
        emailIntent.addFlags(0x10000000);
        if (!TextUtils.isEmpty((CharSequence)subject)) {
            emailIntent.putExtra("android.intent.extra.SUBJECT", subject);
        }
        if (!TextUtils.isEmpty((CharSequence)body)) {
            emailIntent.putExtra("android.intent.extra.TEXT", body);
        }
        return emailIntent;
    }

    public static Intent buildContactCardIntent(String contactId) {
        Intent intent = new Intent("android.intent.action.VIEW");
        Uri uri = Uri.withAppendedPath((Uri)ContactsContract.Contacts.CONTENT_URI, (String)contactId);
        intent.setData(uri);
        intent.addFlags(0x10000000);
        return intent;
    }

    public static Intent buildShareTextIntent(String text) {
        Intent textIntent = new Intent("android.intent.action.SEND");
        textIntent.setType("text/plain");
        textIntent.putExtra("android.intent.extra.TEXT", text);
        return textIntent;
    }

    public static Intent buildApplicationIntent(Context ctx, String packageName, boolean autoInstall) {
        PackageManager pm = ctx.getPackageManager();
        boolean packagePresent = false;
        try {
            pm.getPackageInfo(packageName, 1);
            packagePresent = true;
        }
        catch (PackageManager.NameNotFoundException e) {
            packagePresent = false;
        }
        if (packagePresent) {
            return pm.getLaunchIntentForPackage(packageName);
        }
        return new Intent("android.intent.action.VIEW", Uri.parse((String)("market://details?id=" + packageName)));
    }
}

