/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.robotools.hardware;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Environment;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.util.Log;
import java.io.File;
import java.io.FileFilter;
import java.util.regex.Pattern;

public class RTDevice {
    private static int cachedCoresCount = 0;

    private RTDevice() {
    }

    public static boolean isTablet(Context context) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        int shortSizeDp = (int)(displayMetrics.density * (float)Math.min(displayMetrics.widthPixels, displayMetrics.heightPixels));
        return shortSizeDp > 1024;
    }

    public static float dp2px(Context ctx, float px) {
        return px / ctx.getResources().getDisplayMetrics().density;
    }

    public static float px2dp(Context ctx, float dp) {
        return dp * ctx.getResources().getDisplayMetrics().density;
    }

    public static boolean supportsCamera(Context ctx) {
        return ctx.getPackageManager().hasSystemFeature("android.hardware.camera");
    }

    public static boolean supportsTelephony(Context ctx) {
        return ctx.getPackageManager().hasSystemFeature("android.hardware.telephony");
    }

    public static boolean supportsGps(Context ctx) {
        return ctx.getPackageManager().hasSystemFeature("android.hardware.location");
    }

    public static boolean supportsSms(Context ctx) {
        try {
            if (ctx.getPackageManager().hasSystemFeature("android.hardware.telephony")) {
                TelephonyManager telMgr = (TelephonyManager)ctx.getSystemService("phone");
                int simState = telMgr.getSimState();
                switch (simState) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        return false;
                    }
                    case 5: {
                        return true;
                    }
                }
                return true;
            }
            return false;
        }
        catch (Throwable err) {
            err.printStackTrace();
            return false;
        }
    }

    public static synchronized int getCpuCoresCount() {
        if (cachedCoresCount == 0) {
            try {
                File dir = new File("/sys/devices/system/cpu/");
                File[] files = dir.listFiles(new CpuFilter());
                cachedCoresCount = files.length;
            }
            catch (Exception e) {
                Log.e((String)RTDevice.class.getSimpleName(), (String)e.getMessage(), (Throwable)e);
                cachedCoresCount = 1;
            }
        }
        return cachedCoresCount;
    }

    public static boolean isExternalStorageReady() {
        String state = Environment.getExternalStorageState();
        return !"removed".equals(state) && !"bad_removal".equals(state) && !"unmountable".equals(state) && !"unmounted".equals(state);
    }

    public static File getExternalStorage() {
        return RTDevice.getExternalStorage(null);
    }

    public static File getExternalStorage(String type) {
        File file = Environment.getExternalStoragePublicDirectory((String)type);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public static boolean isConnected(Context ctx) {
        ConnectivityManager cm = (ConnectivityManager)ctx.getSystemService("connectivity");
        NetworkInfo netInfo = cm.getActiveNetworkInfo();
        return netInfo != null && netInfo.isConnected();
    }

    public static boolean isConnectedToWiFi(Context ctx) {
        ConnectivityManager cm = (ConnectivityManager)ctx.getSystemService("connectivity");
        NetworkInfo netInfo = cm.getActiveNetworkInfo();
        return netInfo != null && netInfo.isConnected() && netInfo.getType() == 1;
    }

    public static boolean isConnectedToCellular(Context ctx) {
        ConnectivityManager cm = (ConnectivityManager)ctx.getSystemService("connectivity");
        NetworkInfo netInfo = cm.getActiveNetworkInfo();
        return netInfo != null && netInfo.isConnected() && netInfo.getType() != 1;
    }

    public static boolean isInRoaming(Context ctx) {
        ConnectivityManager cm = (ConnectivityManager)ctx.getSystemService("connectivity");
        NetworkInfo netInfo = cm.getActiveNetworkInfo();
        return netInfo != null && netInfo.getType() != 1 && netInfo.isRoaming();
    }

    public static CharSequence getOwnerEmail(Context context) {
        Account[] accounts = AccountManager.get((Context)context).getAccountsByType("com.google");
        return accounts != null && accounts.length > 0 ? accounts[0].name : null;
    }

    private static class CpuFilter
    implements FileFilter {
        private CpuFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return Pattern.matches("cpu[0-9]", pathname.getName());
        }
    }
}

