/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.robotools.app.design.bottomsheet.model;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.support.v4.internal.view.SupportMenu;
import android.view.KeyEvent;
import android.view.MenuItem;
import android.view.SubMenu;
import eu.livotov.labs.android.robotools.app.design.bottomsheet.model.BottomSheetActionMenuItem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BottomSheetActionMenu
implements SupportMenu {
    private static final int[] sCategoryToOrder = new int[]{1, 4, 5, 3, 2, 0};
    private Context mContext;
    private boolean mIsQwerty;
    private ArrayList<BottomSheetActionMenuItem> mItems;

    public BottomSheetActionMenu(Context context) {
        this.mContext = context;
        this.mItems = new ArrayList();
    }

    public MenuItem add(CharSequence title) {
        return this.add(0, 0, 0, title);
    }

    public Context getContext() {
        return this.mContext;
    }

    private static int findInsertIndex(ArrayList<BottomSheetActionMenuItem> items, int ordering) {
        for (int i = items.size() - 1; i >= 0; --i) {
            BottomSheetActionMenuItem item = items.get(i);
            if (item.getOrder() > ordering) continue;
            return i + 1;
        }
        return 0;
    }

    private static int getOrdering(int categoryOrder) {
        int index = (categoryOrder & 0xFFFF0000) >> 16;
        if (index < 0 || index >= sCategoryToOrder.length) {
            throw new IllegalArgumentException("order does not contain a valid category.");
        }
        return sCategoryToOrder[index] << 16 | categoryOrder & 0xFFFF;
    }

    public MenuItem add(int titleRes) {
        return this.add(0, 0, 0, titleRes);
    }

    public MenuItem add(int groupId, int itemId, int order, CharSequence title) {
        BottomSheetActionMenuItem item = new BottomSheetActionMenuItem(this.getContext(), groupId, itemId, 0, order, title);
        this.mItems.add(BottomSheetActionMenu.findInsertIndex(this.mItems, BottomSheetActionMenu.getOrdering(order)), item);
        return item;
    }

    public MenuItem add(int groupId, int itemId, int order, int titleRes) {
        return this.add(groupId, itemId, order, this.mContext.getResources().getString(titleRes));
    }

    public SubMenu addSubMenu(CharSequence title) {
        return null;
    }

    public SubMenu addSubMenu(int titleRes) {
        return null;
    }

    public SubMenu addSubMenu(int groupId, int itemId, int order, CharSequence title) {
        return null;
    }

    public SubMenu addSubMenu(int groupId, int itemId, int order, int titleRes) {
        return null;
    }

    public int addIntentOptions(int groupId, int itemId, int order, ComponentName caller, Intent[] specifics, Intent intent, int flags, MenuItem[] outSpecificItems) {
        int N;
        PackageManager pm = this.mContext.getPackageManager();
        List lri = pm.queryIntentActivityOptions(caller, specifics, intent, 0);
        int n = N = lri != null ? lri.size() : 0;
        if ((flags & 1) == 0) {
            this.removeGroup(groupId);
        }
        for (int i = 0; i < N; ++i) {
            ResolveInfo ri = (ResolveInfo)lri.get(i);
            Intent rintent = new Intent(ri.specificIndex < 0 ? intent : specifics[ri.specificIndex]);
            rintent.setComponent(new ComponentName(ri.activityInfo.applicationInfo.packageName, ri.activityInfo.name));
            MenuItem item = this.add(groupId, itemId, order, ri.loadLabel(pm)).setIcon(ri.loadIcon(pm)).setIntent(rintent);
            if (outSpecificItems == null || ri.specificIndex < 0) continue;
            outSpecificItems[ri.specificIndex] = item;
        }
        return N;
    }

    public void removeItem(int id) {
        int index = this.findItemIndex(id);
        if (index < 0) {
            return;
        }
        this.mItems.remove(index);
    }

    public void removeGroup(int groupId) {
        ArrayList<BottomSheetActionMenuItem> items = this.mItems;
        int itemCount = items.size();
        int i = 0;
        while (i < itemCount) {
            if (items.get(i).getGroupId() == groupId) {
                items.remove(i);
                --itemCount;
                continue;
            }
            ++i;
        }
    }

    public void clear() {
        this.mItems.clear();
    }

    public void setGroupCheckable(int group, boolean checkable, boolean exclusive) {
        ArrayList<BottomSheetActionMenuItem> items = this.mItems;
        int itemCount = items.size();
        for (int i = 0; i < itemCount; ++i) {
            BottomSheetActionMenuItem item = items.get(i);
            if (item.getGroupId() != group) continue;
            item.setCheckable(checkable);
            item.setExclusiveCheckable(exclusive);
        }
    }

    public void setGroupVisible(int group, boolean visible) {
        ArrayList<BottomSheetActionMenuItem> items = this.mItems;
        int itemCount = items.size();
        for (int i = 0; i < itemCount; ++i) {
            BottomSheetActionMenuItem item = items.get(i);
            if (item.getGroupId() != group) continue;
            item.setVisible(visible);
        }
    }

    public void setGroupEnabled(int group, boolean enabled) {
        ArrayList<BottomSheetActionMenuItem> items = this.mItems;
        int itemCount = items.size();
        for (int i = 0; i < itemCount; ++i) {
            BottomSheetActionMenuItem item = items.get(i);
            if (item.getGroupId() != group) continue;
            item.setEnabled(enabled);
        }
    }

    public boolean hasVisibleItems() {
        ArrayList<BottomSheetActionMenuItem> items = this.mItems;
        int itemCount = items.size();
        for (int i = 0; i < itemCount; ++i) {
            if (!items.get(i).isVisible()) continue;
            return true;
        }
        return false;
    }

    public MenuItem findItem(int id) {
        int index = this.findItemIndex(id);
        if (index < 0) {
            return null;
        }
        return this.mItems.get(index);
    }

    private int findItemIndex(int id) {
        ArrayList<BottomSheetActionMenuItem> items = this.mItems;
        int itemCount = items.size();
        for (int i = 0; i < itemCount; ++i) {
            if (items.get(i).getItemId() != id) continue;
            return i;
        }
        return -1;
    }

    public int size() {
        return this.mItems.size();
    }

    public MenuItem getItem(int index) {
        return this.mItems.get(index);
    }

    public void close() {
    }

    public boolean performShortcut(int keyCode, KeyEvent event, int flags) {
        BottomSheetActionMenuItem item = this.findItemWithShortcut(keyCode, event);
        if (item == null) {
            return false;
        }
        return item.invoke();
    }

    public boolean isShortcutKey(int keyCode, KeyEvent event) {
        return this.findItemWithShortcut(keyCode, event) != null;
    }

    private BottomSheetActionMenuItem findItemWithShortcut(int keyCode, KeyEvent event) {
        boolean qwerty = this.mIsQwerty;
        ArrayList<BottomSheetActionMenuItem> items = this.mItems;
        int itemCount = items.size();
        for (int i = 0; i < itemCount; ++i) {
            char shortcut;
            BottomSheetActionMenuItem item = items.get(i);
            char c = shortcut = qwerty ? item.getAlphabeticShortcut() : item.getNumericShortcut();
            if (keyCode != shortcut) continue;
            return item;
        }
        return null;
    }

    public boolean performIdentifierAction(int id, int flags) {
        int index = this.findItemIndex(id);
        if (index < 0) {
            return false;
        }
        return this.mItems.get(index).invoke();
    }

    public void setQwertyMode(boolean isQwerty) {
        this.mIsQwerty = isQwerty;
    }

    public MenuItem add(BottomSheetActionMenuItem item) {
        this.mItems.add(BottomSheetActionMenu.findInsertIndex(this.mItems, BottomSheetActionMenu.getOrdering(item.getOrder())), item);
        return item;
    }

    public BottomSheetActionMenu clone(int size) {
        BottomSheetActionMenu out = new BottomSheetActionMenu(this.getContext());
        out.mItems = new ArrayList<BottomSheetActionMenuItem>(this.mItems.subList(0, size));
        return out;
    }

    public void removeInvisible() {
        Iterator<BottomSheetActionMenuItem> iter = this.mItems.iterator();
        while (iter.hasNext()) {
            BottomSheetActionMenuItem item = iter.next();
            if (item.isVisible()) continue;
            iter.remove();
        }
    }
}

