/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.robotools.app.design.bottomsheet;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.DrawableRes;
import android.support.annotation.IntegerRes;
import android.support.annotation.MenuRes;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import android.support.annotation.StyleRes;
import android.transition.ChangeBounds;
import android.transition.Transition;
import android.transition.TransitionManager;
import android.util.DisplayMetrics;
import android.util.SparseIntArray;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import android.widget.GridView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.TextView;
import eu.livotov.labs.android.robotools.R;
import eu.livotov.labs.android.robotools.app.design.bottomsheet.adapter.BottomSheetCustomViewAdapter;
import eu.livotov.labs.android.robotools.app.design.bottomsheet.adapter.BottomSheetSimpleSectionedGridAdapter;
import eu.livotov.labs.android.robotools.app.design.bottomsheet.layout.BottomSheetClosableSlidingLayout;
import eu.livotov.labs.android.robotools.app.design.bottomsheet.model.BottomSheetActionMenu;
import eu.livotov.labs.android.robotools.app.design.bottomsheet.model.BottomSheetActionMenuItem;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class RTBottomSheet
extends Dialog
implements DialogInterface {
    private static final String STATUS_BAR_HEIGHT_RES_NAME = "status_bar_height";
    private static final String NAV_BAR_HEIGHT_RES_NAME = "navigation_bar_height";
    private static final String NAV_BAR_HEIGHT_LANDSCAPE_RES_NAME = "navigation_bar_height_landscape";
    private static final String SHOW_NAV_BAR_RES_NAME = "config_showNavigationBar";
    private final SparseIntArray hidden = new SparseIntArray();
    private String moreText;
    private Drawable close;
    private Drawable more;
    private boolean collapseListIcons;
    private int mStatusBarHeight;
    private GridView list;
    private BottomSheetSimpleSectionedGridAdapter adapter;
    private Builder builder;
    private boolean mInPortrait;
    private String sNavBarOverride;
    private boolean mNavBarAvailable;
    private float mSmallestWidthDp;
    private ImageView icon;
    private int limit = -1;
    private boolean cancelOnTouchOutside = true;
    private boolean cancelOnSwipeDown = true;
    private BottomSheetActionMenu fullMenuItem;
    private BottomSheetActionMenu menuItem;
    private BottomSheetActionMenu actions;
    private DialogInterface.OnDismissListener dismissListener;
    private CustomViewResultListener customViewResultListener;
    private View customView;
    private FrameLayout customViewRoot;

    RTBottomSheet(Context context) {
        super(context, R.style.BottomSheet_Dialog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RTBottomSheet(Context context, int theme) {
        super(context, theme);
        TypedArray a = this.getContext().obtainStyledAttributes(null, R.styleable.RTBottomSheet, R.attr.bottomSheetStyle, 0);
        try {
            this.more = a.getDrawable(R.styleable.RTBottomSheet_bs_moreDrawable);
            this.close = a.getDrawable(R.styleable.RTBottomSheet_bs_closeDrawable);
            this.moreText = a.getString(R.styleable.RTBottomSheet_bs_moreText);
            this.collapseListIcons = a.getBoolean(R.styleable.RTBottomSheet_bs_collapseListIcons, true);
        }
        finally {
            a.recycle();
        }
        if (Build.VERSION.SDK_INT >= 19) {
            WindowManager wm = (WindowManager)context.getSystemService("window");
            this.mInPortrait = context.getResources().getConfiguration().orientation == 1;
            try {
                Class<?> c = Class.forName("android.os.SystemProperties");
                Method m = c.getDeclaredMethod("get", String.class);
                m.setAccessible(true);
                this.sNavBarOverride = (String)m.invoke(null, "qemu.hw.mainkeys");
            }
            catch (Throwable e) {
                this.sNavBarOverride = null;
            }
            int[] as = new int[]{16843760};
            a = context.obtainStyledAttributes(as);
            try {
                this.mNavBarAvailable = a.getBoolean(0, false);
            }
            finally {
                a.recycle();
            }
            WindowManager.LayoutParams winParams = ((Activity)context).getWindow().getAttributes();
            int bits = 0x8000000;
            if ((winParams.flags & bits) != 0) {
                this.mNavBarAvailable = true;
            }
            this.mSmallestWidthDp = this.getSmallestWidthDp(wm);
            if (this.mNavBarAvailable) {
                this.setTranslucentStatus(true);
            }
            this.mStatusBarHeight = this.getInternalDimensionSize(context.getResources(), STATUS_BAR_HEIGHT_RES_NAME);
        }
    }

    @SuppressLint(value={"NewApi"})
    private float getSmallestWidthDp(WindowManager wm) {
        DisplayMetrics metrics = new DisplayMetrics();
        if (Build.VERSION.SDK_INT >= 16) {
            wm.getDefaultDisplay().getRealMetrics(metrics);
        } else {
            wm.getDefaultDisplay().getMetrics(metrics);
        }
        float widthDp = (float)metrics.widthPixels / metrics.density;
        float heightDp = (float)metrics.heightPixels / metrics.density;
        return Math.min(widthDp, heightDp);
    }

    @TargetApi(value=19)
    private void setTranslucentStatus(boolean on) {
        Window win = this.getWindow();
        WindowManager.LayoutParams winParams = win.getAttributes();
        int bits = 0x4000000;
        winParams.flags = on ? (winParams.flags |= 0x4000000) : (winParams.flags &= 0xFBFFFFFF);
        win.setAttributes(winParams);
        win.setFlags(0x8000000, 0x8000000);
    }

    private int getInternalDimensionSize(Resources res, String key) {
        int result = 0;
        int resourceId = res.getIdentifier(key, "dimen", "android");
        if (resourceId > 0) {
            result = res.getDimensionPixelSize(resourceId);
        }
        return result;
    }

    @TargetApi(value=14)
    private int getNavigationBarHeight(Context context) {
        Resources res = context.getResources();
        int result = 0;
        if (Build.VERSION.SDK_INT >= 14 && this.hasNavBar(context)) {
            String key;
            if (this.mInPortrait) {
                key = NAV_BAR_HEIGHT_RES_NAME;
            } else {
                if (!this.isNavigationAtBottom()) {
                    return 0;
                }
                key = NAV_BAR_HEIGHT_LANDSCAPE_RES_NAME;
            }
            return this.getInternalDimensionSize(res, key);
        }
        return result;
    }

    @TargetApi(value=14)
    private boolean hasNavBar(Context context) {
        Resources res = context.getResources();
        int resourceId = res.getIdentifier(SHOW_NAV_BAR_RES_NAME, "bool", "android");
        if (resourceId != 0) {
            boolean hasNav = res.getBoolean(resourceId);
            if ("1".equals(this.sNavBarOverride)) {
                hasNav = false;
            } else if ("0".equals(this.sNavBarOverride)) {
                hasNav = true;
            }
            return hasNav;
        }
        return !ViewConfiguration.get((Context)context).hasPermanentMenuKey();
    }

    private boolean isNavigationAtBottom() {
        return this.mSmallestWidthDp >= 600.0f || this.mInPortrait;
    }

    private int getNumColumns() {
        try {
            Field numColumns = GridView.class.getDeclaredField("mRequestedNumColumns");
            numColumns.setAccessible(true);
            return numColumns.getInt(this.list);
        }
        catch (Exception e) {
            return 1;
        }
    }

    public void setCanceledOnSwipeDown(boolean cancel) {
        this.cancelOnSwipeDown = cancel;
    }

    private void init(Context context) {
        this.setCanceledOnTouchOutside(this.cancelOnTouchOutside);
        final BottomSheetClosableSlidingLayout mDialogView = (BottomSheetClosableSlidingLayout)View.inflate((Context)context, (int)(this.builder.customContentView == null ? R.layout.robotools_bs_bottom_sheet_dialog : R.layout.robotools_bs_bottom_customsheet_dialog), null);
        this.setContentView((View)mDialogView);
        if (!this.cancelOnSwipeDown) {
            mDialogView.setSwipeable(this.cancelOnSwipeDown);
        }
        mDialogView.setSlideListener(new BottomSheetClosableSlidingLayout.SlideListener(){

            @Override
            public void onClosed() {
                RTBottomSheet.this.dismiss();
            }

            @Override
            public void onOpened() {
                RTBottomSheet.this.showFullItems();
            }
        });
        this.setOnShowListener(new DialogInterface.OnShowListener(){

            public void onShow(DialogInterface dialogInterface) {
                if (RTBottomSheet.this.list != null) {
                    RTBottomSheet.this.list.setAdapter((ListAdapter)RTBottomSheet.this.adapter);
                    RTBottomSheet.this.list.startLayoutAnimation();
                }
                if (RTBottomSheet.this.builder.icon == null) {
                    RTBottomSheet.this.icon.setVisibility(8);
                } else {
                    RTBottomSheet.this.icon.setVisibility(0);
                    RTBottomSheet.this.icon.setImageDrawable(RTBottomSheet.this.builder.icon);
                }
            }
        });
        int[] location = new int[2];
        mDialogView.getLocationOnScreen(location);
        if (Build.VERSION.SDK_INT >= 19) {
            mDialogView.setPadding(0, location[0] == 0 ? this.mStatusBarHeight : 0, 0, 0);
            mDialogView.getChildAt(0).setPadding(0, 0, 0, this.mNavBarAvailable ? this.getNavigationBarHeight(this.getContext()) + mDialogView.getPaddingBottom() : 0);
        }
        TextView title = (TextView)mDialogView.findViewById(R.id.bottom_sheet_title);
        if (this.builder.title != null) {
            title.setVisibility(0);
            title.setText(this.builder.title);
        }
        this.icon = (ImageView)mDialogView.findViewById(R.id.bottom_sheet_title_image);
        this.list = (GridView)mDialogView.findViewById(R.id.bottom_sheet_gridview);
        this.customViewRoot = (FrameLayout)mDialogView.findViewById(R.id.bottom_sheet_customview);
        if (this.builder.customContentView != null) {
            this.customView = this.builder.customContentView;
            this.customViewRoot.addView(this.customView);
            if (this.customView instanceof BottomSheetCustomViewAdapter) {
                ((BottomSheetCustomViewAdapter)this.customView).setHost(this);
            }
        }
        mDialogView.setmTarget((View)(this.list != null ? this.list : this.customView));
        if (!this.builder.grid && this.list != null) {
            this.list.setNumColumns(1);
        }
        if (this.list != null && this.builder.grid) {
            for (int i = 0; i < this.getMenu().size(); ++i) {
                if (this.getMenu().getItem(i).getIcon() != null) continue;
                throw new IllegalArgumentException("You must set icon for each items in grid style");
            }
        }
        this.limit = this.list != null && this.builder.limit > 0 ? this.builder.limit * this.getNumColumns() : Integer.MAX_VALUE;
        mDialogView.setCollapsible(false);
        this.menuItem = this.actions = this.builder.menu;
        if (this.getMenu().size() > this.limit) {
            this.fullMenuItem = this.builder.menu;
            this.menuItem = this.builder.menu.clone(this.limit - 1);
            BottomSheetActionMenuItem item = new BottomSheetActionMenuItem(context, 0, R.id.bs_more, 0, this.limit - 1, this.moreText);
            item.setIcon(this.more);
            this.menuItem.add(item);
            this.actions = this.menuItem;
            mDialogView.setCollapsible(true);
        }
        BaseAdapter baseAdapter = new BaseAdapter(){

            public int getCount() {
                return RTBottomSheet.this.actions.size() - RTBottomSheet.this.hidden.size();
            }

            public MenuItem getItem(int position) {
                return RTBottomSheet.this.actions.getItem(position);
            }

            public long getItemId(int position) {
                return position;
            }

            public View getView(int position, View convertView, ViewGroup parent) {
                ViewHolder holder;
                if (convertView == null) {
                    LayoutInflater inflater = (LayoutInflater)RTBottomSheet.this.getContext().getSystemService("layout_inflater");
                    convertView = RTBottomSheet.this.builder.grid ? inflater.inflate(R.layout.robotools_bs_grid_entry, parent, false) : inflater.inflate(R.layout.robotools_bs_list_entry, parent, false);
                    holder = new ViewHolder();
                    holder.title = (TextView)convertView.findViewById(R.id.bs_list_title);
                    holder.image = (ImageView)convertView.findViewById(R.id.bs_list_image);
                    convertView.setTag((Object)holder);
                } else {
                    holder = (ViewHolder)convertView.getTag();
                }
                for (int i = 0; i < RTBottomSheet.this.hidden.size(); ++i) {
                    if (RTBottomSheet.this.hidden.valueAt(i) > position) continue;
                    ++position;
                }
                MenuItem item = this.getItem(position);
                holder.title.setText(item.getTitle());
                if (item.getIcon() == null) {
                    holder.image.setVisibility(RTBottomSheet.this.collapseListIcons ? 8 : 4);
                } else {
                    holder.image.setVisibility(0);
                    holder.image.setImageDrawable(item.getIcon());
                }
                holder.image.setEnabled(item.isEnabled());
                holder.title.setEnabled(item.isEnabled());
                return convertView;
            }

            public boolean areAllItemsEnabled() {
                return false;
            }

            public boolean isEnabled(int position) {
                return this.getItem(position).isEnabled();
            }

            public int getViewTypeCount() {
                return 1;
            }

            class ViewHolder {
                private TextView title;
                private ImageView image;

                ViewHolder() {
                }
            }
        };
        if (this.list != null) {
            this.adapter = new BottomSheetSimpleSectionedGridAdapter(context, baseAdapter, R.layout.robotools_bs_list_divider, R.id.headerlayout, R.id.header);
            this.list.setAdapter((ListAdapter)this.adapter);
            this.adapter.setGridView(this.list);
            this.updateSection();
            this.list.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                    if (((MenuItem)RTBottomSheet.this.adapter.getItem(position)).getItemId() == R.id.bs_more) {
                        RTBottomSheet.this.showFullItems();
                        mDialogView.setCollapsible(false);
                        return;
                    }
                    if (!((BottomSheetActionMenuItem)RTBottomSheet.this.adapter.getItem(position)).invoke()) {
                        if (RTBottomSheet.this.builder.menulistener != null) {
                            RTBottomSheet.this.builder.menulistener.onMenuItemClick((MenuItem)RTBottomSheet.this.adapter.getItem(position));
                        } else if (RTBottomSheet.this.builder.listener != null) {
                            RTBottomSheet.this.builder.listener.onClick((DialogInterface)RTBottomSheet.this, ((MenuItem)RTBottomSheet.this.adapter.getItem(position)).getItemId());
                        }
                    }
                    RTBottomSheet.this.dismiss();
                }
            });
        }
        if (this.builder.dismissListener != null) {
            this.setOnDismissListener(this.builder.dismissListener);
        }
        this.setListLayout();
    }

    private void showFullItems() {
        if (Build.VERSION.SDK_INT >= 19) {
            ChangeBounds changeBounds = new ChangeBounds();
            changeBounds.setDuration(300L);
            TransitionManager.beginDelayedTransition((ViewGroup)this.list, (Transition)changeBounds);
        }
        this.actions = this.fullMenuItem;
        this.updateSection();
        this.adapter.notifyDataSetChanged();
        this.list.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        this.icon.setVisibility(0);
        this.icon.setImageDrawable(this.close);
        this.icon.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                RTBottomSheet.this.showShortItems();
            }
        });
        this.setListLayout();
    }

    private void showShortItems() {
        this.actions = this.menuItem;
        this.updateSection();
        this.adapter.notifyDataSetChanged();
        this.setListLayout();
        if (this.builder.icon == null) {
            this.icon.setVisibility(8);
        } else {
            this.icon.setVisibility(0);
            this.icon.setImageDrawable(this.builder.icon);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.init(this.getContext());
        WindowManager.LayoutParams params = this.getWindow().getAttributes();
        params.height = -2;
        params.gravity = 80;
        TypedArray a = this.getContext().obtainStyledAttributes(new int[]{16842996});
        try {
            params.width = a.getLayoutDimension(0, -1);
        }
        finally {
            a.recycle();
        }
        super.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                if (RTBottomSheet.this.dismissListener != null) {
                    RTBottomSheet.this.dismissListener.onDismiss(dialog);
                }
                if (RTBottomSheet.this.limit != Integer.MAX_VALUE) {
                    RTBottomSheet.this.showShortItems();
                }
            }
        });
        this.getWindow().setAttributes(params);
    }

    public void setCanceledOnTouchOutside(boolean cancel) {
        super.setCanceledOnTouchOutside(cancel);
        this.cancelOnTouchOutside = cancel;
    }

    public void setOnDismissListener(DialogInterface.OnDismissListener listener) {
        this.dismissListener = listener;
    }

    public Menu getMenu() {
        return this.builder.menu;
    }

    public void invalidate() {
        this.updateSection();
        this.adapter.notifyDataSetChanged();
        this.setListLayout();
    }

    private void updateSection() {
        this.actions.removeInvisible();
        if (!this.builder.grid && this.actions.size() > 0) {
            int groupId = this.actions.getItem(0).getGroupId();
            ArrayList<BottomSheetSimpleSectionedGridAdapter.Section> sections = new ArrayList<BottomSheetSimpleSectionedGridAdapter.Section>();
            for (int i = 0; i < this.actions.size(); ++i) {
                if (this.actions.getItem(i).getGroupId() == groupId) continue;
                groupId = this.actions.getItem(i).getGroupId();
                sections.add(new BottomSheetSimpleSectionedGridAdapter.Section(i, null));
            }
            if (sections.size() > 0) {
                BottomSheetSimpleSectionedGridAdapter.Section[] s = new BottomSheetSimpleSectionedGridAdapter.Section[sections.size()];
                sections.toArray(s);
                this.adapter.setSections(s);
            } else {
                this.adapter.getmSections().clear();
            }
        }
    }

    private void setListLayout() {
        if (this.list != null) {
            if (!this.hasDivider()) {
                return;
            }
            this.list.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    if (Build.VERSION.SDK_INT < 16) {
                        RTBottomSheet.this.list.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    } else {
                        RTBottomSheet.this.list.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    }
                    View lastChild = RTBottomSheet.this.list.getChildAt(RTBottomSheet.this.list.getChildCount() - 1);
                    if (lastChild != null) {
                        RTBottomSheet.this.list.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, lastChild.getBottom() + lastChild.getPaddingBottom() + RTBottomSheet.this.list.getPaddingBottom()));
                    }
                }
            });
        }
    }

    private boolean hasDivider() {
        return this.adapter != null && this.adapter.getmSections().size() > 0;
    }

    public static interface CustomViewResultListener {
        public void onCustomViewResult(Object var1);
    }

    public static class Builder {
        private final Context context;
        private final BottomSheetActionMenu menu;
        private View customContentView;
        private int theme;
        private CharSequence title;
        private boolean grid;
        private DialogInterface.OnClickListener listener;
        private DialogInterface.OnDismissListener dismissListener;
        private Drawable icon;
        private int limit = -1;
        private MenuItem.OnMenuItemClickListener menulistener;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Builder(@NonNull Activity context) {
            this((Context)context, R.style.BottomSheet_Dialog);
            TypedArray ta = context.getTheme().obtainStyledAttributes(new int[]{R.attr.bottomSheetStyle});
            try {
                this.theme = ta.getResourceId(0, R.style.BottomSheet_Dialog);
            }
            finally {
                ta.recycle();
            }
        }

        public Builder(Context context, @StyleRes int theme) {
            this.context = context;
            this.theme = theme;
            this.menu = new BottomSheetActionMenu(context);
        }

        public Builder sheet(@MenuRes int xmlRes) {
            new MenuInflater(this.context).inflate(xmlRes, (Menu)this.menu);
            this.customContentView = null;
            return this;
        }

        public Builder sheet(int id2, @DrawableRes int iconRes, @StringRes int textRes) {
            BottomSheetActionMenuItem item = new BottomSheetActionMenuItem(this.context, 0, id2, 0, 0, this.context.getText(textRes));
            item.setIcon(iconRes);
            this.menu.add(item);
            this.customContentView = null;
            return this;
        }

        public Builder sheet(int id2, @NonNull Drawable icon, @NonNull CharSequence text) {
            BottomSheetActionMenuItem item = new BottomSheetActionMenuItem(this.context, 0, id2, 0, 0, text);
            item.setIcon(icon);
            this.menu.add(item);
            this.customContentView = null;
            return this;
        }

        public Builder sheet(int id2, @StringRes int textRes) {
            this.menu.add(0, id2, 0, textRes);
            this.customContentView = null;
            return this;
        }

        public Builder sheet(int id2, @NonNull CharSequence text) {
            this.menu.add(0, id2, 0, text);
            this.customContentView = null;
            return this;
        }

        public Builder customView(@NonNull View view) {
            this.customContentView = view;
            this.menu.clear();
            return this;
        }

        public Builder title(@StringRes int titleRes) {
            this.title = this.context.getText(titleRes);
            return this;
        }

        @Deprecated
        public Builder remove(int id2) {
            this.menu.removeItem(id2);
            return this;
        }

        public Builder icon(Drawable icon) {
            this.icon = icon;
            return this;
        }

        public Builder icon(@DrawableRes int iconRes) {
            this.icon = this.context.getResources().getDrawable(iconRes);
            return this;
        }

        public Builder listener(@NonNull DialogInterface.OnClickListener listener) {
            this.listener = listener;
            return this;
        }

        public Builder listener(@NonNull MenuItem.OnMenuItemClickListener listener) {
            this.menulistener = listener;
            return this;
        }

        public Builder darkTheme() {
            this.theme = R.style.BottomSheet_Dialog_Dark;
            return this;
        }

        public RTBottomSheet show() {
            RTBottomSheet dialog = this.build();
            dialog.show();
            return dialog;
        }

        @SuppressLint(value={"Override"})
        public RTBottomSheet build() {
            RTBottomSheet dialog = new RTBottomSheet(this.context, this.theme);
            dialog.builder = this;
            return dialog;
        }

        public Builder grid() {
            this.grid = true;
            return this;
        }

        public Builder limit(@IntegerRes int limitRes) {
            this.limit = this.context.getResources().getInteger(limitRes);
            return this;
        }

        public Builder title(CharSequence title) {
            this.title = title;
            return this;
        }

        public Builder setOnDismissListener(@NonNull DialogInterface.OnDismissListener listener) {
            this.dismissListener = listener;
            return this;
        }
    }
}

