/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.robotools.animation.technique;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.view.View;
import android.view.animation.Interpolator;

public abstract class BaseViewAnimator {
    public static final long DURATION = 1000L;
    private AnimatorSet mAnimatorSet = new AnimatorSet();
    private long mDuration = 1000L;

    protected abstract void prepare(View var1);

    public BaseViewAnimator setTarget(View target) {
        this.reset(target);
        this.prepare(target);
        return this;
    }

    public void animate() {
        this.start();
    }

    public void reset(View target) {
        target.setAlpha(1.0f);
        target.setScaleX(1.0f);
        target.setScaleY(1.0f);
        target.setTranslationX(0.0f);
        target.setTranslationY(0.0f);
        target.setRotation(0.0f);
        target.setRotationY(0.0f);
        target.setRotationX(0.0f);
        target.setPivotX((float)target.getMeasuredWidth() / 2.0f);
        target.setPivotY((float)target.getMeasuredHeight() / 2.0f);
    }

    public void start() {
        this.mAnimatorSet.setDuration(this.mDuration);
        this.mAnimatorSet.start();
    }

    public BaseViewAnimator setDuration(long duration) {
        this.mDuration = duration;
        return this;
    }

    public BaseViewAnimator setStartDelay(long delay) {
        this.getAnimatorAgent().setStartDelay(delay);
        return this;
    }

    public long getStartDelay() {
        return this.mAnimatorSet.getStartDelay();
    }

    public BaseViewAnimator addAnimatorListener(Animator.AnimatorListener l) {
        this.mAnimatorSet.addListener(l);
        return this;
    }

    public void cancel() {
        this.mAnimatorSet.cancel();
    }

    public boolean isRunning() {
        return this.mAnimatorSet.isRunning();
    }

    public boolean isStarted() {
        return this.mAnimatorSet.isStarted();
    }

    public void removeAnimatorListener(Animator.AnimatorListener l) {
        this.mAnimatorSet.removeListener(l);
    }

    public void removeAllListener() {
        this.mAnimatorSet.removeAllListeners();
    }

    public BaseViewAnimator setInterpolator(Interpolator interpolator) {
        this.mAnimatorSet.setInterpolator((TimeInterpolator)interpolator);
        return this;
    }

    public long getDuration() {
        return this.mDuration;
    }

    public AnimatorSet getAnimatorAgent() {
        return this.mAnimatorSet;
    }
}

