/*
 * Decompiled with CFR 0.152.
 */
package eu.hinsch.spring.boot.actuator.logview;

import eu.hinsch.spring.boot.actuator.logview.AbstractFileProvider;
import eu.hinsch.spring.boot.actuator.logview.FileEntry;
import eu.hinsch.spring.boot.actuator.logview.FileType;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.io.IOUtils;

public class TarGzArchiveFileProvider
extends AbstractFileProvider {
    @Override
    public boolean canHandle(Path folder) {
        return this.isTarGz(folder);
    }

    @Override
    public List<FileEntry> getFileEntries(Path folder) throws IOException {
        TarArchiveEntry entry;
        TarArchiveInputStream inputStream = new TarArchiveInputStream((InputStream)new GZIPInputStream(new FileInputStream(folder.toFile())));
        ArrayList<FileEntry> files = new ArrayList<FileEntry>();
        while ((entry = inputStream.getNextTarEntry()) != null) {
            files.add(TarGzArchiveFileProvider.createFileEntry(entry));
        }
        return files;
    }

    private static FileEntry createFileEntry(TarArchiveEntry entry) {
        FileEntry fileEntry = new FileEntry();
        try {
            fileEntry.setFilename(URLEncoder.encode(entry.getName(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("encoding error", e);
        }
        fileEntry.setDisplayFilename(entry.getName());
        fileEntry.setSize(entry.getSize());
        fileEntry.setFileType(entry.isDirectory() ? FileType.DIRECTORY : FileType.FILE);
        fileEntry.setModified(FileTime.fromMillis(entry.getLastModifiedDate().getTime()));
        fileEntry.setModifiedPretty(prettyTime.format(new Date(entry.getLastModifiedDate().getTime())));
        return fileEntry;
    }

    @Override
    public void streamContent(Path folder, String filename, OutputStream stream) throws IOException {
        TarArchiveEntry entry;
        TarArchiveInputStream tarStream = new TarArchiveInputStream((InputStream)new GZIPInputStream(new FileInputStream(folder.toFile())));
        while ((entry = tarStream.getNextTarEntry()) != null) {
            if (!entry.getName().equals(filename)) continue;
            IOUtils.copy((InputStream)new ByteArrayInputStream(IOUtils.toByteArray((InputStream)tarStream)), (OutputStream)stream);
        }
    }
}

