/*
 * Decompiled with CFR 0.152.
 */
package eu.hinsch.spring.boot.actuator.logview;

import eu.hinsch.spring.boot.actuator.logview.FileEntry;
import eu.hinsch.spring.boot.actuator.logview.FileProvider;
import eu.hinsch.spring.boot.actuator.logview.FileSystemFileProvider;
import eu.hinsch.spring.boot.actuator.logview.FileType;
import eu.hinsch.spring.boot.actuator.logview.SortBy;
import eu.hinsch.spring.boot.actuator.logview.TarGzArchiveFileProvider;
import eu.hinsch.spring.boot.actuator.logview.ZipArchiveFileProvider;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpoint;
import org.springframework.ui.Model;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

public class LogViewEndpoint
implements MvcEndpoint {
    private final List<FileProvider> fileProviders;
    private final Configuration freemarkerConfig;
    private final String loggingPath;
    private final List<String> stylesheets;

    public LogViewEndpoint(String loggingPath, List<String> stylesheets) {
        this.loggingPath = loggingPath;
        this.stylesheets = stylesheets;
        this.fileProviders = Arrays.asList(new FileSystemFileProvider(), new ZipArchiveFileProvider(), new TarGzArchiveFileProvider());
        this.freemarkerConfig = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
        this.freemarkerConfig.setClassForTemplateLoading(this.getClass(), "/templates");
    }

    @RequestMapping
    public void redirect(HttpServletResponse response) throws IOException {
        response.sendRedirect("log/");
    }

    @RequestMapping(value={"/"})
    @ResponseBody
    public String list(Model model, @RequestParam(required=false, defaultValue="FILENAME") SortBy sortBy, @RequestParam(required=false, defaultValue="false") boolean desc, @RequestParam(required=false) String base) throws IOException, TemplateException {
        Path currentFolder = this.loggingPath(base);
        this.securityCheck(currentFolder, null);
        List<FileEntry> files = this.getFileProvider(currentFolder).getFileEntries(currentFolder);
        List<FileEntry> sortedFiles = this.sortFiles(files, sortBy, desc);
        model.addAttribute("sortBy", (Object)sortBy);
        model.addAttribute("desc", (Object)desc);
        model.addAttribute("files", sortedFiles);
        model.addAttribute("currentFolder", (Object)currentFolder.toAbsolutePath().toString());
        model.addAttribute("base", (Object)(base != null ? URLEncoder.encode(base, "UTF-8") : ""));
        model.addAttribute("parent", (Object)this.getParent(currentFolder));
        model.addAttribute("stylesheets", this.stylesheets);
        return FreeMarkerTemplateUtils.processTemplateIntoString((Template)this.freemarkerConfig.getTemplate("logview.ftl"), (Object)model);
    }

    private FileProvider getFileProvider(Path folder) {
        return this.fileProviders.stream().filter(provider -> provider.canHandle(folder)).findFirst().orElseThrow(() -> new RuntimeException("no file provider found for " + folder.toString()));
    }

    private String getParent(Path loggingPath) {
        Path basePath = this.loggingPath(null);
        String parent = "";
        if (!basePath.toString().equals(loggingPath.toString()) && (parent = loggingPath.getParent().toString()).startsWith(basePath.toString())) {
            parent = parent.substring(basePath.toString().length());
        }
        return parent;
    }

    private Path loggingPath(String base) {
        return base != null ? Paths.get(this.loggingPath, base) : Paths.get(this.loggingPath, new String[0]);
    }

    private List<FileEntry> sortFiles(List<FileEntry> files, SortBy sortBy, boolean desc) {
        Comparator comparator = null;
        switch (sortBy) {
            case FILENAME: {
                comparator = (a, b) -> a.getFilename().compareTo(b.getFilename());
                break;
            }
            case SIZE: {
                comparator = (a, b) -> Long.compare(a.getSize(), b.getSize());
                break;
            }
            case MODIFIED: {
                comparator = (a, b) -> Long.compare(a.getModified().toMillis(), b.getModified().toMillis());
            }
        }
        List<FileEntry> sortedFiles = files.stream().sorted(comparator).collect(Collectors.toList());
        if (desc) {
            Collections.reverse(sortedFiles);
        }
        return sortedFiles;
    }

    @RequestMapping(value={"/view"})
    public void view(@RequestParam String filename, @RequestParam(required=false) String base, @RequestParam(required=false) Integer tailLines, HttpServletResponse response) throws IOException {
        Path path = this.loggingPath(base);
        this.securityCheck(path, filename);
        response.setContentType("text/plain");
        FileProvider fileProvider = this.getFileProvider(path);
        if (tailLines != null) {
            fileProvider.tailContent(path, filename, (OutputStream)response.getOutputStream(), tailLines);
        } else {
            fileProvider.streamContent(path, filename, (OutputStream)response.getOutputStream());
        }
    }

    @RequestMapping(value={"/search"})
    public void search(@RequestParam String term, HttpServletResponse response) throws IOException {
        Path folder = this.loggingPath(null);
        List<FileEntry> files = this.getFileProvider(folder).getFileEntries(folder);
        List<FileEntry> sortedFiles = this.sortFiles(files, SortBy.MODIFIED, false);
        response.setContentType("text/plain");
        ServletOutputStream outputStream = response.getOutputStream();
        sortedFiles.stream().filter(file -> file.getFileType().equals((Object)FileType.FILE)).forEach(file -> this.searchAndStreamFile((FileEntry)file, term, (OutputStream)outputStream));
    }

    private void searchAndStreamFile(FileEntry fileEntry, String term, OutputStream outputStream) {
        Path folder = this.loggingPath(null);
        try {
            List lines = IOUtils.readLines((InputStream)new FileInputStream(new File(folder.toFile().toString(), fileEntry.getFilename()))).stream().filter(line -> line.contains(term)).map(line -> "[" + fileEntry.getFilename() + "] " + line).collect(Collectors.toList());
            for (String line2 : lines) {
                outputStream.write(line2.getBytes());
                outputStream.write(System.lineSeparator().getBytes());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("error reading file", e);
        }
    }

    private void securityCheck(Path base, String filename) {
        try {
            String canonicalLoggingPath = (filename != null ? new File(base.toFile().toString(), filename) : new File(base.toFile().toString())).getCanonicalPath();
            String baseCanonicalPath = new File(this.loggingPath).getCanonicalPath();
            String errorMessage = "File " + base.toString() + "/" + filename + " may not be located outside base path " + this.loggingPath;
            Assert.isTrue((boolean)canonicalLoggingPath.startsWith(baseCanonicalPath), (String)errorMessage);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public String getPath() {
        return "/log";
    }

    public boolean isSensitive() {
        return true;
    }

    public Class<? extends Endpoint> getEndpointType() {
        return null;
    }
}

