/*
 * Decompiled with CFR 0.152.
 */
package eu.hinsch.spring.boot.actuator.logview;

import eu.hinsch.spring.boot.actuator.logview.FileEntry;
import eu.hinsch.spring.boot.actuator.logview.FileProvider;
import eu.hinsch.spring.boot.actuator.logview.FileSystemFileProvider;
import eu.hinsch.spring.boot.actuator.logview.FileType;
import eu.hinsch.spring.boot.actuator.logview.SortBy;
import eu.hinsch.spring.boot.actuator.logview.TarGzArchiveFileProvider;
import eu.hinsch.spring.boot.actuator.logview.ZipArchiveFileProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.ui.Model;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Component
@ConditionalOnProperty(value={"logging.path"})
public class LogViewEndpoint
implements MvcEndpoint {
    private Environment environment;
    private static List<FileProvider> fileProviders;

    @Autowired
    public LogViewEndpoint(Environment environment) {
        this.environment = environment;
        fileProviders = Arrays.asList(new FileSystemFileProvider(), new ZipArchiveFileProvider(), new TarGzArchiveFileProvider());
    }

    @RequestMapping(value={"/"})
    public String list(Model model, @RequestParam(required=false, defaultValue="FILENAME") SortBy sortBy, @RequestParam(required=false, defaultValue="false") boolean desc, @RequestParam(required=false) String base) throws IOException {
        this.securityCheck(base);
        Path currentFolder = this.loggingPath(base);
        List<FileEntry> files = this.getFileProvider(currentFolder).getFileEntries(currentFolder);
        List<FileEntry> sortedFiles = this.sortFiles(files, sortBy, desc);
        model.addAttribute("sortBy", (Object)sortBy);
        model.addAttribute("desc", (Object)desc);
        model.addAttribute("files", sortedFiles);
        model.addAttribute("currentFolder", (Object)currentFolder.toAbsolutePath().toString());
        model.addAttribute("base", (Object)(base != null ? base : ""));
        model.addAttribute("parent", (Object)this.getParent(currentFolder));
        return "logview";
    }

    private FileProvider getFileProvider(Path folder) {
        return fileProviders.stream().filter(provider -> provider.canHandle(folder)).findFirst().orElseThrow(() -> new RuntimeException("no file provider found for " + folder.toString()));
    }

    private String getParent(Path loggingPath) {
        Path basePath = this.loggingPath(null);
        String parent = "";
        if (!basePath.toString().equals(loggingPath.toString()) && (parent = loggingPath.getParent().toString()).startsWith(basePath.toString())) {
            parent = parent.substring(basePath.toString().length());
        }
        return parent;
    }

    private Path loggingPath(String base) {
        String loggingPath = this.environment.getProperty("logging.path");
        return base != null ? Paths.get(loggingPath, base) : Paths.get(loggingPath, new String[0]);
    }

    private List<FileEntry> sortFiles(List<FileEntry> files, SortBy sortBy, boolean desc) {
        Comparator comparator = null;
        switch (sortBy) {
            case FILENAME: {
                comparator = (a, b) -> a.getFilename().compareTo(b.getFilename());
                break;
            }
            case SIZE: {
                comparator = (a, b) -> Long.compare(a.getSize(), b.getSize());
                break;
            }
            case MODIFIED: {
                comparator = (a, b) -> Long.compare(a.getModified().toMillis(), b.getModified().toMillis());
            }
        }
        List<FileEntry> sortedFiles = files.stream().sorted(comparator).collect(Collectors.toList());
        if (desc) {
            Collections.reverse(sortedFiles);
        }
        return sortedFiles;
    }

    @RequestMapping(value={"/view/{filename}/"})
    public void view(@PathVariable String filename, @RequestParam(required=false) String base, HttpServletResponse response) throws IOException {
        this.securityCheck(filename);
        Path path = this.loggingPath(base);
        this.getFileProvider(path).streamContent(path, filename, (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/search"})
    public void search(@RequestParam String term, HttpServletResponse response) throws IOException {
        Path folder = this.loggingPath(null);
        List<FileEntry> files = this.getFileProvider(folder).getFileEntries(folder);
        List<FileEntry> sortedFiles = this.sortFiles(files, SortBy.MODIFIED, false);
        ServletOutputStream outputStream = response.getOutputStream();
        sortedFiles.stream().filter(file -> file.getFileType().equals((Object)FileType.FILE)).forEach(file -> this.searchAndStreamFile((FileEntry)file, term, (OutputStream)outputStream));
    }

    private void searchAndStreamFile(FileEntry fileEntry, String term, OutputStream outputStream) {
        Path folder = this.loggingPath(null);
        try {
            List lines = IOUtils.readLines((InputStream)new FileInputStream(new File(folder.toFile().toString(), fileEntry.getFilename()))).stream().filter(line -> line.contains(term)).map(line -> "[" + fileEntry.getFilename() + "] " + line).collect(Collectors.toList());
            for (String line2 : lines) {
                outputStream.write(line2.getBytes());
                outputStream.write(System.lineSeparator().getBytes());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("error reading file", e);
        }
    }

    private void securityCheck(String filename) {
        Assert.doesNotContain((String)filename, (String)"..");
    }

    public String getPath() {
        return "/log";
    }

    public boolean isSensitive() {
        return true;
    }

    public Class<? extends Endpoint> getEndpointType() {
        return null;
    }
}

