/*
 * Decompiled with CFR 0.152.
 */
package eu.hinsch.spring.boot.actuator.logview;

import eu.hinsch.spring.boot.actuator.logview.AbstractFileProvider;
import eu.hinsch.spring.boot.actuator.logview.FileEntry;
import eu.hinsch.spring.boot.actuator.logview.FileType;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class FileSystemFileProvider
extends AbstractFileProvider {
    @Override
    public boolean canHandle(Path folder) {
        return folder.toFile().isDirectory();
    }

    @Override
    public List<FileEntry> getFileEntries(Path loggingPath) throws IOException {
        ArrayList<FileEntry> files = new ArrayList<FileEntry>();
        Files.newDirectoryStream(loggingPath).forEach(path -> files.add(this.createFileEntry((Path)path)));
        return files;
    }

    private FileEntry createFileEntry(Path path) {
        FileEntry fileEntry = new FileEntry();
        fileEntry.setFilename(path.getFileName().toString());
        try {
            fileEntry.setModified(Files.getLastModifiedTime(path, new LinkOption[0]));
            fileEntry.setSize(Files.size(path));
        }
        catch (IOException e) {
            throw new RuntimeException("unable to retrieve file attribute", e);
        }
        fileEntry.setModifiedPretty(prettyTime.format(new Date(fileEntry.getModified().toMillis())));
        fileEntry.setFileType(this.getFileType(path));
        return fileEntry;
    }

    private FileType getFileType(Path path) {
        FileType fileType = path.toFile().isDirectory() ? FileType.DIRECTORY : (this.isArchive(path) ? FileType.ARCHIVE : FileType.FILE);
        return fileType;
    }

    @Override
    public void streamContent(Path folder, String filename, OutputStream stream) throws IOException {
        IOUtils.copy((InputStream)new FileInputStream(Paths.get(folder.toString(), filename).toFile()), (OutputStream)stream);
    }
}

