/*
 * Decompiled with CFR 0.152.
 */
package eu.eventstorm.test;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.junit.jupiter.api.Assertions;

public final class Tests {
    private Tests() {
    }

    public static void assertUtilClassIsWellDefined(Class<?> clazz) throws Exception {
        Tests.assertSingletonClassIsWellDefined(clazz);
        Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
        constructor.setAccessible(true);
        constructor.newInstance(new Object[0]);
        constructor.setAccessible(false);
        for (Method method : clazz.getMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || !method.getDeclaringClass().equals(clazz)) continue;
            Assertions.fail((String)("there exists a non-static method:" + method));
        }
    }

    public static void assertSingletonClassIsWellDefined(Class<?> clazz) throws Exception {
        Assertions.assertTrue((boolean)Modifier.isFinal(clazz.getModifiers()), (String)"class must be final");
        Assertions.assertEquals((int)1, (int)clazz.getDeclaredConstructors().length, (String)"There must be only one constructor");
        Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
        if (constructor.isAccessible() || !Modifier.isPrivate(constructor.getModifiers())) {
            Assertions.fail((String)"constructor is not private");
        }
    }
}

