/*
 * Decompiled with CFR 0.152.
 */
package eu.eventstorm.test;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;

public final class LoggerInstancePostProcessor
implements TestInstancePostProcessor {
    public void postProcessTestInstance(Object o, ExtensionContext extensionContext) throws Exception {
        String travis;
        String level = System.getProperty("log4j2.level");
        if (level != null) {
            LoggerInstancePostProcessor.configLoggers(Level.valueOf((String)level));
        }
        if ((travis = System.getProperty("travis")) != null) {
            this.removeAllAppenders();
        }
    }

    private static void configLoggers(Level level) {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig("");
        loggerConfig.setLevel(level);
        for (LoggerConfig lc : config.getLoggers().values()) {
            lc.setLevel(level);
        }
        ctx.updateLoggers();
    }

    private void removeAllAppenders() {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig("");
        loggerConfig.getAppenderRefs().forEach(a -> {
            loggerConfig.removeAppender(a.getRef());
            for (LoggerConfig lc : config.getLoggers().values()) {
                lc.removeAppender(a.getRef());
            }
        });
        ctx.updateLoggers();
    }
}

