/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.scope;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.enumerations.SignatureScopeType;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.validation.scope.SignatureScopeWithTransformations;
import java.util.List;
import java.util.Objects;

public class ManifestEntrySignatureScope
extends SignatureScopeWithTransformations {
    private static final long serialVersionUID = 8764813918985821868L;
    private final String manifestName;

    public ManifestEntrySignatureScope(String entryName, Digest digest, String manifestName, List<String> transformations) {
        super(entryName, digest, transformations);
        this.manifestName = manifestName;
    }

    @Override
    public String getDescription() {
        String description = DomUtils.isElementReference(this.getName()) ? String.format("The XML Manifest Entry with ID '%s' from a Manifest with name '%s'", this.getName(), this.manifestName) : String.format("The File Manifest Entry with name '%s' from a Manifest with name '%s'", this.getName(), this.manifestName);
        return this.addTransformationIfNeeded(description);
    }

    @Override
    public SignatureScopeType getType() {
        return SignatureScopeType.FULL;
    }

    @Override
    public String toString() {
        return "ManifestEntrySignatureScope{manifestName='" + this.manifestName + '\'' + "} " + super.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ManifestEntrySignatureScope)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ManifestEntrySignatureScope that = (ManifestEntrySignatureScope)o;
        return Objects.equals(this.manifestName, that.manifestName);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.manifestName != null ? this.manifestName.hashCode() : 0);
        return result;
    }
}

