/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp.utilities;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.time.ZonedDateTime;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class SugarUtil {
    public static String zonedDateTimeToString(ZonedDateTime zonedDateTime) {
        if (zonedDateTime == null) {
            return "";
        }
        return zonedDateTime.toString();
    }

    public static String docToString(Document doc) {
        try {
            StringWriter sw = new StringWriter();
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(new DOMSource(doc), new StreamResult(sw));
            return sw.toString();
        }
        catch (Exception ex) {
            throw new RuntimeException("Error converting to String", ex);
        }
    }

    public static String soapMessageToString(SOAPMessage message) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            message.writeTo((OutputStream)out);
        }
        catch (IOException | SOAPException e) {
            return "";
        }
        return new String(out.toByteArray());
    }
}

