/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp.utilities;

import eu.chargetime.ocpp.utilities.SugarUtil;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public final class MoreObjects {
    private MoreObjects() {
        throw new AssertionError((Object)"No Objects instances should exist");
    }

    public static boolean equals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static boolean deepEquals(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return Arrays.deepEquals(new Object[]{a}, new Object[]{b});
    }

    public static int hashCode(Object o) {
        return o != null ? o.hashCode() : 0;
    }

    public static int hash(Object ... values) {
        return Arrays.hashCode(values);
    }

    public static <T> T[] clone(T[] array) {
        return array == null ? null : Arrays.copyOf(array, array.length);
    }

    public static byte[] clone(byte[] array) {
        return array == null ? null : Arrays.copyOf(array, array.length);
    }

    public static ToStringHelper toStringHelper(Object self) {
        return new ToStringHelper(self);
    }

    public static ToStringHelper toStringHelper(Object self, boolean outputFullDetails) {
        return new ToStringHelper(self, outputFullDetails);
    }

    public static ToStringHelper toStringHelper(Class<?> clazz) {
        return new ToStringHelper(clazz);
    }

    public static ToStringHelper toStringHelper(Class<?> clazz, boolean outputFullDetails) {
        return new ToStringHelper(clazz, outputFullDetails);
    }

    public static ToStringHelper toStringHelper(String className) {
        return new ToStringHelper(className);
    }

    public static ToStringHelper toStringHelper(String className, boolean outputFullDetails) {
        return new ToStringHelper(className, outputFullDetails);
    }

    public static final class ToStringHelperImpl {
        private final String className;
        private final ValueHolder holderHead;
        private ValueHolder holderTail;
        private boolean omitNullValues;

        private ToStringHelperImpl(String className) {
            this.holderTail = this.holderHead = new ValueHolder();
            this.omitNullValues = false;
            this.className = className;
        }

        public ToStringHelperImpl omitNullValues() {
            this.omitNullValues = true;
            return this;
        }

        public ToStringHelperImpl add(String name, Object value) {
            return this.addHolder(name, value);
        }

        public ToStringHelperImpl add(String name, ZonedDateTime value) {
            return this.addHolder(name, value);
        }

        public ToStringHelperImpl add(String name, boolean value) {
            return this.addHolder(name, String.valueOf(value));
        }

        public ToStringHelperImpl add(String name, char value) {
            return this.addHolder(name, String.valueOf(value));
        }

        public ToStringHelperImpl add(String name, double value) {
            return this.addHolder(name, String.valueOf(value));
        }

        public ToStringHelperImpl add(String name, float value) {
            return this.addHolder(name, String.valueOf(value));
        }

        public ToStringHelperImpl add(String name, int value) {
            return this.addHolder(name, String.valueOf(value));
        }

        public ToStringHelperImpl add(String name, long value) {
            return this.addHolder(name, String.valueOf(value));
        }

        public ToStringHelperImpl addValue(Object value) {
            return this.addHolder(value);
        }

        public ToStringHelperImpl addValue(boolean value) {
            return this.addHolder(String.valueOf(value));
        }

        public ToStringHelperImpl addValue(char value) {
            return this.addHolder(String.valueOf(value));
        }

        public ToStringHelperImpl addValue(double value) {
            return this.addHolder(String.valueOf(value));
        }

        public ToStringHelperImpl addValue(float value) {
            return this.addHolder(String.valueOf(value));
        }

        public ToStringHelperImpl addValue(int value) {
            return this.addHolder(String.valueOf(value));
        }

        public ToStringHelperImpl addValue(long value) {
            return this.addHolder(String.valueOf(value));
        }

        public String toString() {
            boolean omitNullValuesSnapshot = this.omitNullValues;
            String nextSeparator = "";
            StringBuilder builder = new StringBuilder(32).append(this.className).append('{');
            ValueHolder valueHolder = this.holderHead.next;
            while (valueHolder != null) {
                Object value = valueHolder.value;
                if (!omitNullValuesSnapshot || value != null) {
                    builder.append(nextSeparator);
                    nextSeparator = ", ";
                    if (valueHolder.name != null) {
                        builder.append(valueHolder.name).append('=');
                    }
                    if (value != null && value.getClass().isArray()) {
                        Object[] objectArray = new Object[]{value};
                        String arrayString = Arrays.deepToString(objectArray);
                        builder.append(arrayString, 1, arrayString.length() - 1);
                    } else {
                        builder.append(value);
                    }
                }
                valueHolder = valueHolder.next;
            }
            return builder.append('}').toString();
        }

        private ValueHolder addHolder() {
            ValueHolder valueHolder;
            this.holderTail = this.holderTail.next = (valueHolder = new ValueHolder());
            return valueHolder;
        }

        private ToStringHelperImpl addHolder(Object value) {
            ValueHolder valueHolder = this.addHolder();
            valueHolder.value = value;
            return this;
        }

        private ToStringHelperImpl addHolder(String name, Object value) {
            ValueHolder valueHolder = this.addHolder();
            valueHolder.value = value;
            valueHolder.name = name;
            return this;
        }

        private ToStringHelperImpl addHolder(String name, ZonedDateTime value) {
            ValueHolder valueHolder = this.addHolder();
            valueHolder.value = "\"" + SugarUtil.zonedDateTimeToString(value) + "\"";
            valueHolder.name = name;
            return this;
        }

        private static final class ValueHolder {
            String name;
            Object value;
            ValueHolder next;

            private ValueHolder() {
            }
        }
    }

    public static final class ToStringHelper {
        public static final int MAXIMUM_ARRAY_SIZE_TO_OUTPUT_DETAILS = 32;
        public static final String FIELD_NAME_LENGTH_POSTFIX = ".length";
        public static final String FIELD_NAME_SIZE_POSTFIX = ".size";
        public static final String SECURE_FIELD_VALUE_REPLACEMENT = "********";
        private final boolean outputFullDetails;
        private final ToStringHelperImpl helperImplementation;

        private ToStringHelper(ToStringHelperImpl helperImplementation, boolean outputFullDetails) {
            this.helperImplementation = helperImplementation;
            this.outputFullDetails = outputFullDetails;
        }

        private ToStringHelper(Object self) {
            this(ToStringHelper.toStringHelper(self), false);
        }

        private ToStringHelper(Class<?> clazz) {
            this(ToStringHelper.toStringHelper(clazz), false);
        }

        private ToStringHelper(String className) {
            this(ToStringHelper.toStringHelper(className), false);
        }

        private ToStringHelper(Object self, boolean outputFullDetails) {
            this(ToStringHelper.toStringHelper(self), outputFullDetails);
        }

        private ToStringHelper(Class<?> clazz, boolean outputFullDetails) {
            this(ToStringHelper.toStringHelper(clazz), outputFullDetails);
        }

        private ToStringHelper(String className, boolean outputFullDetails) {
            this(ToStringHelper.toStringHelper(className), outputFullDetails);
        }

        public ToStringHelper omitNullValues() {
            this.helperImplementation.omitNullValues();
            return this;
        }

        public ToStringHelper add(String name, Object value) {
            this.helperImplementation.add(name, value);
            return this;
        }

        public ToStringHelper add(String name, ZonedDateTime value) {
            this.helperImplementation.add(name, value);
            return this;
        }

        public ToStringHelper add(String name, boolean value) {
            this.helperImplementation.add(name, String.valueOf(value));
            return this;
        }

        public ToStringHelper add(String name, char value) {
            this.helperImplementation.add(name, String.valueOf(value));
            return this;
        }

        public ToStringHelper add(String name, double value) {
            this.helperImplementation.add(name, String.valueOf(value));
            return this;
        }

        public ToStringHelper add(String name, float value) {
            this.helperImplementation.add(name, String.valueOf(value));
            return this;
        }

        public ToStringHelper add(String name, int value) {
            this.helperImplementation.add(name, String.valueOf(value));
            return this;
        }

        public ToStringHelper add(String name, long value) {
            this.helperImplementation.add(name, String.valueOf(value));
            return this;
        }

        public ToStringHelper add(String name, List<?> value) {
            return this.addCollection(name, value);
        }

        public ToStringHelper add(String name, Set<?> value) {
            return this.addCollection(name, value);
        }

        public ToStringHelper add(String name, Map<?, ?> value) {
            return this.addMap(name, value);
        }

        public ToStringHelper add(String name, Queue<?> value) {
            return this.addCollection(name, value);
        }

        private ToStringHelper addCollection(String name, Collection<?> value) {
            if (value != null && !this.outputFullDetails) {
                this.helperImplementation.add(name + FIELD_NAME_SIZE_POSTFIX, value.size());
            } else {
                this.helperImplementation.add(name, value);
            }
            return this;
        }

        private ToStringHelper addMap(String name, Map<?, ?> value) {
            if (value != null && !this.outputFullDetails) {
                this.helperImplementation.add(name + FIELD_NAME_SIZE_POSTFIX, value.size());
            } else {
                this.helperImplementation.add(name, value);
            }
            return this;
        }

        public <T> ToStringHelper add(String name, T[] value) {
            if (value != null && !this.outputFullDetails) {
                this.helperImplementation.add(name + FIELD_NAME_LENGTH_POSTFIX, value.length);
            } else {
                this.helperImplementation.add(name, Arrays.toString(value));
            }
            return this;
        }

        public ToStringHelper add(String name, byte[] value) {
            if (value != null && value.length > 32 && !this.outputFullDetails) {
                this.helperImplementation.add(name + FIELD_NAME_LENGTH_POSTFIX, value.length);
            } else {
                this.helperImplementation.add(name, Arrays.toString(value));
            }
            return this;
        }

        public ToStringHelper add(String name, boolean[] value) {
            if (value != null && value.length > 32 && !this.outputFullDetails) {
                this.helperImplementation.add(name + FIELD_NAME_LENGTH_POSTFIX, value.length);
            } else {
                this.helperImplementation.add(name, Arrays.toString(value));
            }
            return this;
        }

        public ToStringHelper add(String name, char[] value) {
            if (value != null && value.length > 32 && !this.outputFullDetails) {
                this.helperImplementation.add(name + FIELD_NAME_LENGTH_POSTFIX, value.length);
            } else {
                this.helperImplementation.add(name, Arrays.toString(value));
            }
            return this;
        }

        public ToStringHelper add(String name, double[] value) {
            if (value != null && value.length > 32 && !this.outputFullDetails) {
                this.helperImplementation.add(name + FIELD_NAME_LENGTH_POSTFIX, value.length);
            } else {
                this.helperImplementation.add(name, Arrays.toString(value));
            }
            return this;
        }

        public ToStringHelper add(String name, float[] value) {
            if (value != null && value.length > 32 && !this.outputFullDetails) {
                this.helperImplementation.add(name + FIELD_NAME_LENGTH_POSTFIX, value.length);
            } else {
                this.helperImplementation.add(name, Arrays.toString(value));
            }
            return this;
        }

        public ToStringHelper add(String name, int[] value) {
            if (value != null && value.length > 32 && !this.outputFullDetails) {
                this.helperImplementation.add(name + FIELD_NAME_LENGTH_POSTFIX, value.length);
            } else {
                this.helperImplementation.add(name, Arrays.toString(value));
            }
            return this;
        }

        public ToStringHelper add(String name, long[] value) {
            if (value != null && value.length > 32 && !this.outputFullDetails) {
                this.helperImplementation.add(name + FIELD_NAME_LENGTH_POSTFIX, value.length);
            } else {
                this.helperImplementation.add(name, Arrays.toString(value));
            }
            return this;
        }

        public ToStringHelper addSecure(String name, String value) {
            value = SECURE_FIELD_VALUE_REPLACEMENT;
            this.helperImplementation.add(name, value);
            return this;
        }

        public ToStringHelper addValue(Object value) {
            this.helperImplementation.addValue(value);
            return this;
        }

        public ToStringHelper addValue(boolean value) {
            this.helperImplementation.addValue(String.valueOf(value));
            return this;
        }

        public ToStringHelper addValue(char value) {
            this.helperImplementation.addValue(String.valueOf(value));
            return this;
        }

        public ToStringHelper addValue(double value) {
            this.helperImplementation.addValue(String.valueOf(value));
            return this;
        }

        public ToStringHelper addValue(float value) {
            this.helperImplementation.addValue(String.valueOf(value));
            return this;
        }

        public ToStringHelper addValue(int value) {
            this.helperImplementation.addValue(String.valueOf(value));
            return this;
        }

        public ToStringHelper addValue(long value) {
            this.helperImplementation.addValue(String.valueOf(value));
            return this;
        }

        public String toString() {
            return this.helperImplementation.toString();
        }

        static ToStringHelperImpl toStringHelper(Object self) {
            return new ToStringHelperImpl(self.getClass().getSimpleName());
        }

        static ToStringHelperImpl toStringHelper(Class<?> clazz) {
            return new ToStringHelperImpl(clazz.getSimpleName());
        }

        public static ToStringHelperImpl toStringHelper(String className) {
            return new ToStringHelperImpl(className);
        }
    }
}

