/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp;

import eu.chargetime.ocpp.Communicator;
import eu.chargetime.ocpp.CommunicatorEvents;
import eu.chargetime.ocpp.ConfirmationHandler;
import eu.chargetime.ocpp.IFeatureRepository;
import eu.chargetime.ocpp.ISession;
import eu.chargetime.ocpp.PromiseFulfiller;
import eu.chargetime.ocpp.PropertyConstraintException;
import eu.chargetime.ocpp.Queue;
import eu.chargetime.ocpp.RequestDispatcher;
import eu.chargetime.ocpp.SessionEvents;
import eu.chargetime.ocpp.UnsupportedFeatureException;
import eu.chargetime.ocpp.feature.Feature;
import eu.chargetime.ocpp.model.Confirmation;
import eu.chargetime.ocpp.model.Request;
import eu.chargetime.ocpp.utilities.MoreObjects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Session
implements ISession {
    private static final Logger logger = LoggerFactory.getLogger(Session.class);
    private final UUID sessionId = UUID.randomUUID();
    private final Communicator communicator;
    private final Queue queue;
    private final RequestDispatcher dispatcher;
    private final IFeatureRepository featureRepository;
    private SessionEvents events;

    public Session(Communicator communicator, Queue queue, PromiseFulfiller fulfiller, IFeatureRepository featureRepository) {
        this.communicator = communicator;
        this.queue = queue;
        this.dispatcher = new RequestDispatcher(fulfiller);
        this.featureRepository = featureRepository;
    }

    @Override
    public UUID getSessionId() {
        return this.sessionId;
    }

    @Override
    public void sendRequest(String action, Request payload, String uuid) {
        this.communicator.sendCall(uuid, action, payload);
    }

    @Override
    public String storeRequest(Request payload) {
        return this.queue.store(payload);
    }

    public void sendConfirmation(String uniqueId, String action, Confirmation confirmation) {
        this.communicator.sendCallResult(uniqueId, action, confirmation);
    }

    private Optional<Class<? extends Confirmation>> getConfirmationType(String uniqueId) throws UnsupportedFeatureException {
        Optional<Request> requestOptional = this.queue.restoreRequest(uniqueId);
        if (requestOptional.isPresent()) {
            Optional<Feature> featureOptional = this.featureRepository.findFeature(requestOptional.get());
            if (featureOptional.isPresent()) {
                return Optional.of(featureOptional.get().getConfirmationType());
            }
            logger.debug("Feature for request with id: {} not found in session: {}", (Object)uniqueId, (Object)this);
            throw new UnsupportedFeatureException("Error with getting confirmation type by request id = " + uniqueId);
        }
        logger.debug("Request with id: {} not found in session: {}", (Object)uniqueId, (Object)this);
        return Optional.empty();
    }

    @Override
    public void open(String uri, SessionEvents eventHandler) {
        this.events = eventHandler;
        this.dispatcher.setEventHandler(eventHandler);
        this.communicator.connect(uri, new CommunicatorEventHandler());
    }

    @Override
    public void close() {
        this.communicator.disconnect();
    }

    @Override
    public void accept(SessionEvents eventHandler) {
        this.events = eventHandler;
        this.dispatcher.setEventHandler(eventHandler);
        this.communicator.accept(new CommunicatorEventHandler());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Session session = (Session)o;
        return MoreObjects.equals(this.sessionId, session.sessionId);
    }

    public int hashCode() {
        return MoreObjects.hash(this.sessionId);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("sessionId", this.sessionId).add("communicator", this.communicator).add("queue", this.queue).add("dispatcher", this.dispatcher).add("featureRepository", this.featureRepository).add("events", this.events).toString();
    }

    private class CommunicatorEventHandler
    implements CommunicatorEvents {
        private static final String OCCURENCE_CONSTRAINT_VIOLATION = "Payload for Action is syntactically correct but at least one of the fields violates occurence constraints";
        private static final String INTERNAL_ERROR = "An internal error occurred and the receiver was not able to process the requested Action successfully";
        private static final String UNABLE_TO_PROCESS = "Unable to process action";

        private CommunicatorEventHandler() {
        }

        @Override
        public void onCallResult(String id, String action, Object payload) {
            try {
                Optional confirmationTypeOptional = Session.this.getConfirmationType(id);
                if (confirmationTypeOptional.isPresent()) {
                    Confirmation confirmation = (Confirmation)Session.this.communicator.unpackPayload(payload, (Class)confirmationTypeOptional.get());
                    if (confirmation.validate()) {
                        Session.this.events.handleConfirmation(id, confirmation);
                    } else {
                        Session.this.communicator.sendCallError(id, action, "OccurenceConstraintViolation", OCCURENCE_CONSTRAINT_VIOLATION);
                    }
                } else {
                    logger.warn(INTERNAL_ERROR);
                    Session.this.communicator.sendCallError(id, action, "InternalError", INTERNAL_ERROR);
                }
            }
            catch (PropertyConstraintException ex) {
                logger.warn(ex.getMessage(), (Throwable)ex);
                Session.this.communicator.sendCallError(id, action, "TypeConstraintViolation", ex.getMessage());
            }
            catch (UnsupportedFeatureException ex) {
                logger.warn(INTERNAL_ERROR, (Throwable)ex);
                Session.this.communicator.sendCallError(id, action, "InternalError", INTERNAL_ERROR);
            }
            catch (Exception ex) {
                logger.warn(UNABLE_TO_PROCESS, (Throwable)ex);
                Session.this.communicator.sendCallError(id, action, "FormationViolation", UNABLE_TO_PROCESS);
            }
        }

        @Override
        public synchronized void onCall(String id, String action, Object payload) {
            Optional<Feature> featureOptional = Session.this.featureRepository.findFeature(action);
            if (!featureOptional.isPresent()) {
                Session.this.communicator.sendCallError(id, action, "NotImplemented", "Requested Action is not known by receiver");
            } else {
                try {
                    Request request = Session.this.communicator.unpackPayload(payload, featureOptional.get().getRequestType());
                    if (request.validate()) {
                        CompletableFuture<Confirmation> promise = Session.this.dispatcher.handleRequest(request);
                        promise.whenComplete((BiConsumer)new ConfirmationHandler(id, action, Session.this.communicator));
                    } else {
                        Session.this.communicator.sendCallError(id, action, "OccurenceConstraintViolation", OCCURENCE_CONSTRAINT_VIOLATION);
                    }
                }
                catch (PropertyConstraintException ex) {
                    logger.warn(ex.getMessage(), (Throwable)ex);
                    Session.this.communicator.sendCallError(id, action, "TypeConstraintViolation", ex.getMessage());
                }
                catch (Exception ex) {
                    logger.warn(UNABLE_TO_PROCESS, (Throwable)ex);
                    Session.this.communicator.sendCallError(id, action, "FormationViolation", UNABLE_TO_PROCESS);
                }
            }
        }

        @Override
        public void onError(String id, String errorCode, String errorDescription, Object payload) {
            Session.this.events.handleError(id, errorCode, errorDescription, payload);
        }

        @Override
        public void onDisconnected() {
            Session.this.events.handleConnectionClosed();
        }

        @Override
        public void onConnected() {
            Session.this.events.handleConnectionOpened();
        }
    }
}

