/*
 * Decompiled with CFR 0.152.
 */
package eu.chainfire.libsuperuser;

import android.os.Build;
import eu.chainfire.libsuperuser.Debug;
import eu.chainfire.libsuperuser.Shell;
import java.util.List;
import java.util.Locale;

public class Toolbox {
    private static final int TOYBOX_SDK = 23;
    private static final Object synchronizer = new Object();
    private static volatile String toybox = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        if (toybox != null) {
            return;
        }
        if (Build.VERSION.SDK_INT < 23) {
            toybox = "";
        } else {
            if (Debug.getSanityChecksEnabledEffective() && Debug.onMainThread()) {
                Debug.log("Application attempted to init the Toolbox class from the main thread");
                throw new Shell.ShellOnMainThreadException("Application attempted to init the Toolbox class from the main thread");
            }
            Object object = synchronizer;
            synchronized (object) {
                toybox = "";
                List<String> output = Shell.SH.run("toybox");
                if (output != null) {
                    toybox = " ";
                    for (String line : output) {
                        toybox = toybox + line.trim() + " ";
                    }
                }
            }
        }
    }

    public static String command(String format, Object ... args) {
        int p;
        if (Build.VERSION.SDK_INT < 23) {
            return String.format(Locale.ENGLISH, "toolbox " + format, args);
        }
        if (toybox == null) {
            Toolbox.init();
        }
        String applet = (p = (format = format.trim()).indexOf(32)) >= 0 ? format.substring(0, p) : format;
        if (toybox.contains(" " + applet + " ")) {
            return String.format(Locale.ENGLISH, "toybox " + format, args);
        }
        return String.format(Locale.ENGLISH, "toolbox " + format, args);
    }
}

