/*
 * Decompiled with CFR 0.152.
 */
package eu.chainfire.libsuperuser;

import eu.chainfire.libsuperuser.Debug;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Locale;

public class StreamGobbler
extends Thread {
    private static int threadCounter = 0;
    private final String shell;
    private final InputStream inputStream;
    private final BufferedReader reader;
    private final List<String> writer;
    private final OnLineListener lineListener;
    private final OnStreamClosedListener streamClosedListener;
    private volatile boolean active = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int incThreadCounter() {
        Class<StreamGobbler> clazz = StreamGobbler.class;
        synchronized (StreamGobbler.class) {
            int ret = threadCounter++;
            // ** MonitorExit[var0] (shouldn't be in output)
            return ret;
        }
    }

    public StreamGobbler(String shell, InputStream inputStream, List<String> outputList) {
        super("Gobbler#" + String.valueOf(StreamGobbler.incThreadCounter()));
        this.shell = shell;
        this.inputStream = inputStream;
        this.reader = new BufferedReader(new InputStreamReader(inputStream));
        this.writer = outputList;
        this.lineListener = null;
        this.streamClosedListener = null;
    }

    public StreamGobbler(String shell, InputStream inputStream, OnLineListener onLineListener, OnStreamClosedListener onStreamClosedListener) {
        super("Gobbler#" + String.valueOf(StreamGobbler.incThreadCounter()));
        this.shell = shell;
        this.inputStream = inputStream;
        this.reader = new BufferedReader(new InputStreamReader(inputStream));
        this.lineListener = onLineListener;
        this.streamClosedListener = onStreamClosedListener;
        this.writer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        boolean calledOnClose;
        block13: {
            calledOnClose = false;
            try {
                String line;
                while ((line = this.reader.readLine()) != null) {
                    Debug.logOutput(String.format(Locale.ENGLISH, "[%s] %s", this.shell, line));
                    if (this.writer != null) {
                        this.writer.add(line);
                    }
                    if (this.lineListener != null) {
                        this.lineListener.onLine(line);
                    }
                    while (!this.active) {
                        StreamGobbler streamGobbler = this;
                        synchronized (streamGobbler) {
                            try {
                                this.wait(128L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            catch (IOException e) {
                if (this.streamClosedListener == null) break block13;
                calledOnClose = true;
                this.streamClosedListener.onStreamClosed();
            }
        }
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!calledOnClose && this.streamClosedListener != null) {
            this.streamClosedListener.onStreamClosed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeGobbling() {
        if (!this.active) {
            StreamGobbler streamGobbler = this;
            synchronized (streamGobbler) {
                this.active = true;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendGobbling() {
        StreamGobbler streamGobbler = this;
        synchronized (streamGobbler) {
            this.active = false;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForSuspend() {
        StreamGobbler streamGobbler = this;
        synchronized (streamGobbler) {
            while (this.active) {
                try {
                    this.wait(32L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSuspended() {
        StreamGobbler streamGobbler = this;
        synchronized (streamGobbler) {
            return !this.active;
        }
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OnLineListener getOnLineListener() {
        return this.lineListener;
    }

    public static interface OnStreamClosedListener {
        public void onStreamClosed();
    }

    public static interface OnLineListener {
        public void onLine(String var1);
    }
}

