/*
 * Decompiled with CFR 0.152.
 */
package eu.chainfire.libsuperuser;

import androidx.annotation.AnyThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import eu.chainfire.libsuperuser.Debug;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Locale;

public class StreamGobbler
extends Thread {
    private static int threadCounter = 0;
    @NonNull
    private final String shell;
    @NonNull
    private final InputStream inputStream;
    @NonNull
    private final BufferedReader reader;
    @Nullable
    private final List<String> writer;
    @Nullable
    private final OnLineListener lineListener;
    @Nullable
    private final OnStreamClosedListener streamClosedListener;
    private volatile boolean active = true;
    private volatile boolean calledOnClose = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int incThreadCounter() {
        Class<StreamGobbler> clazz = StreamGobbler.class;
        synchronized (StreamGobbler.class) {
            int ret = threadCounter++;
            // ** MonitorExit[var0] (shouldn't be in output)
            return ret;
        }
    }

    @AnyThread
    public StreamGobbler(@NonNull String shell, @NonNull InputStream inputStream, @Nullable List<String> outputList) {
        super("Gobbler#" + StreamGobbler.incThreadCounter());
        this.shell = shell;
        this.inputStream = inputStream;
        this.reader = new BufferedReader(new InputStreamReader(inputStream));
        this.writer = outputList;
        this.lineListener = null;
        this.streamClosedListener = null;
    }

    @AnyThread
    public StreamGobbler(@NonNull String shell, @NonNull InputStream inputStream, @Nullable OnLineListener onLineListener, @Nullable OnStreamClosedListener onStreamClosedListener) {
        super("Gobbler#" + StreamGobbler.incThreadCounter());
        this.shell = shell;
        this.inputStream = inputStream;
        this.reader = new BufferedReader(new InputStreamReader(inputStream));
        this.lineListener = onLineListener;
        this.streamClosedListener = onStreamClosedListener;
        this.writer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        block13: {
            try {
                String line;
                while ((line = this.reader.readLine()) != null) {
                    Debug.logOutput(String.format(Locale.ENGLISH, "[%s] %s", this.shell, line));
                    if (this.writer != null) {
                        this.writer.add(line);
                    }
                    if (this.lineListener != null) {
                        this.lineListener.onLine(line);
                    }
                    while (!this.active) {
                        StreamGobbler streamGobbler = this;
                        synchronized (streamGobbler) {
                            try {
                                this.wait(128L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            catch (IOException e) {
                if (this.streamClosedListener == null) break block13;
                this.calledOnClose = true;
                this.streamClosedListener.onStreamClosed();
            }
        }
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!this.calledOnClose && this.streamClosedListener != null) {
            this.calledOnClose = true;
            this.streamClosedListener.onStreamClosed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    public void resumeGobbling() {
        if (!this.active) {
            StreamGobbler streamGobbler = this;
            synchronized (streamGobbler) {
                this.active = true;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    public void suspendGobbling() {
        StreamGobbler streamGobbler = this;
        synchronized (streamGobbler) {
            this.active = false;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public void waitForSuspend() {
        StreamGobbler streamGobbler = this;
        synchronized (streamGobbler) {
            while (this.active) {
                try {
                    this.wait(32L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    public boolean isSuspended() {
        StreamGobbler streamGobbler = this;
        synchronized (streamGobbler) {
            return !this.active;
        }
    }

    @NonNull
    @AnyThread
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Nullable
    @AnyThread
    public OnLineListener getOnLineListener() {
        return this.lineListener;
    }

    void conditionalJoin() throws InterruptedException {
        if (this.calledOnClose) {
            return;
        }
        if (Thread.currentThread() == this) {
            return;
        }
        this.join();
    }

    public static interface OnStreamClosedListener {
        public void onStreamClosed();
    }

    public static interface OnLineListener {
        public void onLine(String var1);
    }
}

