/*
 * Decompiled with CFR 0.152.
 */
package eu.chainfire.libsuperuser;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import androidx.annotation.AnyThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import eu.chainfire.libsuperuser.Debug;
import eu.chainfire.libsuperuser.MarkerInputStream;
import eu.chainfire.libsuperuser.StreamGobbler;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class Shell {
    private static volatile boolean redirectDeprecated = true;
    protected static final String[] availableTestCommands = new String[]{"echo -BOC-", "id"};

    public static boolean isRedirectDeprecated() {
        return redirectDeprecated;
    }

    public static void setRedirectDeprecated(boolean redirectDeprecated) {
        Shell.redirectDeprecated = redirectDeprecated;
    }

    @Deprecated
    @Nullable
    @WorkerThread
    public static List<String> run(@NonNull String shell, @NonNull String[] commands, boolean wantSTDERR) {
        return Shell.run(shell, commands, null, wantSTDERR);
    }

    @Deprecated
    @Nullable
    @WorkerThread
    public static List<String> run(@NonNull String shell, @NonNull String[] commands, @Nullable String[] environment, boolean wantSTDERR) {
        String shellUpper = shell.toUpperCase(Locale.ENGLISH);
        if (Debug.getSanityChecksEnabledEffective() && Debug.onMainThread()) {
            Debug.log("Application attempted to run a shell command from the main thread");
            throw new ShellOnMainThreadException("Application attempted to run a shell command from the main thread");
        }
        if (redirectDeprecated) {
            return Pool.getWrapper(shell).run(commands, environment, wantSTDERR);
        }
        Debug.logCommand(String.format(Locale.ENGLISH, "[%s%%] START", shellUpper));
        List<String> res = Collections.synchronizedList(new ArrayList());
        try {
            StreamGobbler STDERR;
            StreamGobbler STDOUT;
            DataOutputStream STDIN;
            Process process;
            block14: {
                if (environment != null) {
                    HashMap<String, String> newEnvironment = new HashMap<String, String>(System.getenv());
                    for (String entry : environment) {
                        int split = entry.indexOf("=");
                        if (split < 0) continue;
                        newEnvironment.put(entry.substring(0, split), entry.substring(split + 1));
                    }
                    int i = 0;
                    environment = new String[newEnvironment.size()];
                    for (Map.Entry entry : newEnvironment.entrySet()) {
                        environment[i] = (String)entry.getKey() + "=" + (String)entry.getValue();
                        ++i;
                    }
                }
                process = Runtime.getRuntime().exec(shell, environment);
                STDIN = new DataOutputStream(process.getOutputStream());
                STDOUT = new StreamGobbler(shellUpper + "-", process.getInputStream(), res);
                STDERR = new StreamGobbler(shellUpper + "*", process.getErrorStream(), wantSTDERR ? res : null);
                STDOUT.start();
                STDERR.start();
                try {
                    for (String write : commands) {
                        Debug.logCommand(String.format(Locale.ENGLISH, "[%s+] %s", shellUpper, write));
                        STDIN.write((write + "\n").getBytes("UTF-8"));
                        STDIN.flush();
                    }
                    STDIN.write("exit\n".getBytes("UTF-8"));
                    STDIN.flush();
                }
                catch (IOException e) {
                    if (e.getMessage().contains("EPIPE") || e.getMessage().contains("Stream closed")) break block14;
                    throw e;
                }
            }
            process.waitFor();
            try {
                STDIN.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            STDOUT.join();
            STDERR.join();
            process.destroy();
            if (SU.isSU(shell) && process.exitValue() == 255) {
                res = null;
            }
        }
        catch (IOException e) {
            res = null;
        }
        catch (InterruptedException e) {
            res = null;
        }
        Debug.logCommand(String.format(Locale.ENGLISH, "[%s%%] END", shell.toUpperCase(Locale.ENGLISH)));
        return res;
    }

    protected static boolean parseAvailableResult(@Nullable List<String> ret, boolean checkForRoot) {
        if (ret == null) {
            return false;
        }
        boolean echo_seen = false;
        for (String line : ret) {
            if (line.contains("uid=")) {
                return !checkForRoot || line.contains("uid=0");
            }
            if (!line.contains("-BOC-")) continue;
            echo_seen = true;
        }
        return echo_seen;
    }

    static class Garbage {
        static final ArrayList<Threaded> shells = new ArrayList();

        Garbage() {
        }

        @AnyThread
        static synchronized void protect(@NonNull Threaded shell) {
            if (shells.indexOf(shell) == -1) {
                shells.add(shell);
            }
        }

        @AnyThread
        static synchronized void collect(@NonNull Threaded shell) {
            if (shells.indexOf(shell) != -1) {
                shells.remove(shell);
            }
        }
    }

    public static class Pool {
        public static final OnNewBuilderListener defaultOnNewBuilderListener = new OnNewBuilderListener(){

            @Override
            @NonNull
            public Builder newBuilder() {
                return new Builder().setWantSTDERR(true).setWatchdogTimeout(0).setMinimalLogging(false);
            }
        };
        @Nullable
        private static OnNewBuilderListener onNewBuilderListener = null;
        @NonNull
        private static final Map<String, ArrayList<Threaded>> pool = new HashMap<String, ArrayList<Threaded>>();
        private static int poolSize = 4;
        public static final PoolWrapper SH = Pool.getWrapper("sh");
        public static final PoolWrapper SU = Pool.getWrapper("su");

        @Nullable
        @AnyThread
        public static synchronized OnNewBuilderListener getOnNewBuilderListener() {
            return onNewBuilderListener;
        }

        @AnyThread
        public static synchronized void setOnNewBuilderListener(@Nullable OnNewBuilderListener onNewBuilderListener) {
            Pool.onNewBuilderListener = onNewBuilderListener;
        }

        @AnyThread
        public static synchronized int getPoolSize() {
            return poolSize;
        }

        @AnyThread
        public static synchronized void setPoolSize(int poolSize) {
            if ((poolSize = Math.max(poolSize, 1)) != Pool.poolSize) {
                Pool.poolSize = poolSize;
                Pool.cleanup(null, false);
            }
        }

        @NonNull
        @AnyThread
        private static synchronized Builder newBuilder() {
            if (onNewBuilderListener != null) {
                return onNewBuilderListener.newBuilder();
            }
            return defaultOnNewBuilderListener.newBuilder();
        }

        @NonNull
        @AnyThread
        public static Threaded getUnpooled(@NonNull String shell) {
            return Pool.getUnpooled(shell, null);
        }

        @NonNull
        @AnyThread
        public static Threaded getUnpooled(@NonNull String shell, @Nullable OnShellOpenResultListener onShellOpenResultListener) {
            return Pool.newInstance(shell, onShellOpenResultListener, false);
        }

        private static Threaded newInstance(@NonNull String shell, @Nullable OnShellOpenResultListener onShellOpenResultListener, boolean pooled) {
            Debug.logPool(String.format(Locale.ENGLISH, "newInstance(shell:%s, pooled:%d)", shell, pooled ? 1 : 0));
            return Pool.newBuilder().setShell(shell).openThreadedEx(onShellOpenResultListener, pooled);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void cleanup(@Nullable Threaded toRemove, boolean removeAll) {
            String[] keySet;
            Map<String, ArrayList<Threaded>> object = pool;
            synchronized (object) {
                keySet = pool.keySet().toArray(new String[0]);
            }
            for (String key : keySet) {
                ArrayList<Threaded> shellsModify = pool.get(key);
                if (shellsModify == null) continue;
                ArrayList shellsCheck = (ArrayList)shellsModify.clone();
                int wantedTotal = eu.chainfire.libsuperuser.Shell$SU.isSU(key) ? poolSize : 1;
                int haveTotal = 0;
                int haveAvailable = 0;
                for (int i = shellsCheck.size() - 1; i >= 0; --i) {
                    Threaded threaded = (Threaded)shellsCheck.get(i);
                    if (!threaded.isRunning() || threaded == toRemove || removeAll) {
                        Debug.logPool("shell removed");
                        shellsCheck.remove(threaded);
                        Map<String, ArrayList<Threaded>> map = pool;
                        synchronized (map) {
                            shellsModify.remove(threaded);
                        }
                        if (!removeAll) continue;
                        threaded.closeWhenIdle();
                        continue;
                    }
                    ++haveTotal;
                    if (threaded.isReserved()) continue;
                    ++haveAvailable;
                }
                if (haveTotal > wantedTotal && haveAvailable > 1) {
                    int kill = Math.min(haveAvailable - 1, haveTotal - wantedTotal);
                    for (int i = shellsCheck.size() - 1; i >= 0; --i) {
                        Threaded threaded = (Threaded)shellsCheck.get(i);
                        if (threaded.isReserved() || !threaded.isIdle()) continue;
                        Debug.logPool("shell killed");
                        shellsCheck.remove(threaded);
                        Map<String, ArrayList<Threaded>> map = pool;
                        synchronized (map) {
                            shellsModify.remove(threaded);
                        }
                        threaded.closeWhenIdle(true);
                        if (--kill == 0) break;
                    }
                }
                Map<String, ArrayList<Threaded>> map = pool;
                synchronized (map) {
                    if (shellsModify.size() == 0) {
                        pool.remove(key);
                    }
                }
            }
            if (Debug.getDebug()) {
                Map<String, ArrayList<Threaded>> map = pool;
                synchronized (map) {
                    for (String key : pool.keySet()) {
                        int reserved = 0;
                        ArrayList<Threaded> shells = pool.get(key);
                        if (shells == null) continue;
                        for (int i = 0; i < shells.size(); ++i) {
                            if (!shells.get(i).isReserved()) continue;
                            ++reserved;
                        }
                        Debug.logPool(String.format(Locale.ENGLISH, "cleanup: shell:%s count:%d reserved:%d", key, shells.size(), reserved));
                    }
                }
            }
        }

        @NonNull
        @AnyThread
        public static Threaded get(@NonNull String shell) throws ShellDiedException {
            return Pool.get(shell, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SuppressLint(value={"WrongThread"})
        @NonNull
        @AnyThread
        public static Threaded get(@NonNull String shell, final @Nullable OnShellOpenResultListener onShellOpenResultListener) throws ShellDiedException {
            Threaded threaded = null;
            String shellUpper = shell.toUpperCase(Locale.ENGLISH);
            Class<Pool> clazz = Pool.class;
            synchronized (Pool.class) {
                Pool.cleanup(null, false);
                ArrayList<Threaded> shells = pool.get(shellUpper);
                if (shells != null) {
                    for (Threaded instance : shells) {
                        if (instance.isReserved()) continue;
                        threaded = instance;
                        threaded.setReserved(true);
                        break;
                    }
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                if (threaded == null) {
                    threaded = Pool.newInstance(shell, onShellOpenResultListener, true);
                    if (!threaded.isRunning()) {
                        throw new ShellDiedException();
                    }
                    if (!(Debug.getSanityChecksEnabledEffective() && Debug.onMainThread() || threaded.waitForOpened(null))) {
                        throw new ShellDiedException();
                    }
                    clazz = Pool.class;
                    synchronized (Pool.class) {
                        if (!threaded.wasPoolRemoveCalled()) {
                            if (pool.get(shellUpper) == null) {
                                pool.put(shellUpper, new ArrayList());
                            }
                            pool.get(shellUpper).add(threaded);
                        }
                        // ** MonitorExit[var4_4] (shouldn't be in output)
                    }
                } else if (onShellOpenResultListener != null) {
                    final Threaded fThreaded = threaded;
                    threaded.startCallback();
                    threaded.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                onShellOpenResultListener.onOpenResult(true, 0);
                            }
                            finally {
                                fThreaded.endCallback();
                            }
                        }
                    });
                }
                return threaded;
            }
        }

        private static synchronized void releaseReservation(@NonNull Threaded threaded) {
            Debug.logPool("releaseReservation");
            threaded.setReserved(false);
            Pool.cleanup(null, false);
        }

        private static synchronized void removeShell(@NonNull Threaded threaded) {
            Debug.logPool("removeShell");
            Pool.cleanup(threaded, false);
        }

        @AnyThread
        public static synchronized void closeAll() {
            Pool.cleanup(null, true);
        }

        @AnyThread
        public static PoolWrapper getWrapper(@NonNull String shell) {
            if (shell.toUpperCase(Locale.ENGLISH).equals("SH") && SH != null) {
                return SH;
            }
            if (shell.toUpperCase(Locale.ENGLISH).equals("SU") && SU != null) {
                return SU;
            }
            return new PoolWrapper(shell);
        }

        public static interface OnNewBuilderListener {
            @NonNull
            public Builder newBuilder();
        }
    }

    public static class PoolWrapper
    implements DeprecatedSyncCommands,
    SyncCommands {
        private final String shellCommand;

        @AnyThread
        public PoolWrapper(@NonNull String shell) {
            this.shellCommand = shell;
        }

        @NonNull
        @AnyThread
        public Threaded get() throws ShellDiedException {
            return Pool.get(this.shellCommand);
        }

        @NonNull
        @AnyThread
        public Threaded get(@Nullable OnShellOpenResultListener onShellOpenResultListener) throws ShellDiedException {
            return Pool.get(this.shellCommand, onShellOpenResultListener);
        }

        @NonNull
        @AnyThread
        public Threaded getUnpooled() {
            return Pool.getUnpooled(this.shellCommand);
        }

        @NonNull
        @AnyThread
        public Threaded getUnpooled(@Nullable OnShellOpenResultListener onShellOpenResultListener) {
            return Pool.getUnpooled(this.shellCommand, onShellOpenResultListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        @Deprecated
        @Nullable
        @WorkerThread
        public List<String> run(@NonNull Object commands, final boolean wantSTDERR) {
            try (Threaded shell = this.get();){
                final int[] exitCode = new int[1];
                final ArrayList<String> output = new ArrayList<String>();
                shell.addCommand(commands, 0, new OnCommandResultListener2(){

                    @Override
                    public void onCommandResult(int commandCode, int intExitCode, @NonNull List<String> intSTDOUT, @NonNull List<String> intSTDERR) {
                        exitCode[0] = intExitCode;
                        output.addAll(intSTDOUT);
                        if (wantSTDERR) {
                            output.addAll(intSTDERR);
                        }
                    }
                });
                shell.waitForIdle();
                if (exitCode[0] < 0) {
                    List<String> list = null;
                    return list;
                }
                ArrayList<String> arrayList = output;
                return arrayList;
            }
            catch (ShellDiedException e) {
                return null;
            }
        }

        @Override
        @Deprecated
        @Nullable
        @WorkerThread
        public List<String> run(@NonNull Object commands, @Nullable String[] environment, boolean wantSTDERR) {
            String[] _commands;
            if (environment == null) {
                return this.run(commands, wantSTDERR);
            }
            if (commands instanceof String) {
                _commands = new String[]{(String)commands};
            } else if (commands instanceof List) {
                _commands = ((List)commands).toArray(new String[0]);
            } else if (commands instanceof String[]) {
                _commands = (String[])commands;
            } else {
                throw new IllegalArgumentException("commands parameter must be of type String, List<String> or String[]");
            }
            StringBuilder sb = new StringBuilder();
            for (String entry : environment) {
                int split = entry.indexOf("=");
                if (split < 0) continue;
                boolean quoted = entry.substring(split + 1, split + 2).equals("\"");
                sb.append(entry, 0, split);
                sb.append(quoted ? "=" : "=\"");
                sb.append(entry.substring(split + 1));
                sb.append(quoted ? " " : "\" ");
            }
            sb.append("sh -c \"\n");
            for (String line : _commands) {
                sb.append(line);
                sb.append("\n");
            }
            sb.append("\"");
            return this.run((Object)new String[]{sb.toString().replace("\\", "\\\\").replace("$", "\\$")}, wantSTDERR);
        }

        @Override
        @WorkerThread
        public int run(@NonNull Object commands) throws ShellDiedException {
            return this.run(commands, null, null, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @WorkerThread
        public int run(@NonNull Object commands, @Nullable List<String> STDOUT, @Nullable List<String> STDERR, boolean clear) throws ShellDiedException {
            try (Threaded shell = this.get();){
                int n = shell.run(commands, STDOUT, STDERR, clear);
                return n;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @WorkerThread
        public int run(@NonNull Object commands, @NonNull OnSyncCommandLineListener onSyncCommandLineListener) throws ShellDiedException {
            try (Threaded shell = this.get();){
                int n = shell.run(commands, onSyncCommandLineListener);
                return n;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @WorkerThread
        public int run(@NonNull Object commands, @NonNull OnSyncCommandInputStreamListener onSyncCommandInputStreamListener) throws ShellDiedException {
            try (Threaded shell = this.get();){
                int n = shell.run(commands, onSyncCommandInputStreamListener);
                return n;
            }
        }
    }

    @TargetApi(value=19)
    public static class ThreadedAutoCloseable
    extends Threaded
    implements AutoCloseable {
        protected ThreadedAutoCloseable(@NonNull Builder builder, OnShellOpenResultListener onShellOpenResultListener, boolean pooled) {
            super(builder, onShellOpenResultListener, pooled);
        }
    }

    public static class Threaded
    extends Interactive {
        private static int threadCounter = 0;
        @NonNull
        private final HandlerThread handlerThread;
        private final boolean pooled;
        private final Object onCloseCalledSync = new Object();
        private volatile boolean onClosedCalled = false;
        private final Object onPoolRemoveCalledSync = new Object();
        private volatile boolean onPoolRemoveCalled = false;
        private volatile boolean reserved = true;
        private volatile boolean closeEvenIfPooled = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static int incThreadCounter() {
            Class<Threaded> clazz = Threaded.class;
            synchronized (Threaded.class) {
                int ret = threadCounter++;
                // ** MonitorExit[var0] (shouldn't be in output)
                return ret;
            }
        }

        private static Handler createHandlerThread() {
            HandlerThread handlerThread = new HandlerThread("Shell.Threaded#" + Threaded.incThreadCounter());
            handlerThread.start();
            return new Handler(handlerThread.getLooper());
        }

        protected Threaded(Builder builder, OnShellOpenResultListener onShellOpenResultListener, boolean pooled) {
            super(builder.setHandler(Threaded.createHandlerThread()).setDetectOpen(true).setShellDiesOnSTDOUTERRClose(true), onShellOpenResultListener);
            this.handlerThread = (HandlerThread)this.handler.getLooper().getThread();
            this.pooled = pooled;
            if (this.pooled) {
                this.protect();
            }
        }

        @Override
        protected void finalize() throws Throwable {
            if (this.pooled) {
                this.closed = true;
            }
            super.finalize();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void protect() {
            Object object = this.onCloseCalledSync;
            synchronized (object) {
                if (!this.onClosedCalled) {
                    Garbage.protect(this);
                }
            }
        }

        private void collect() {
            Garbage.collect(this);
        }

        @Override
        @AnyThread
        public void close() {
            this.protect();
            if (this.pooled) {
                super.closeWhenIdle();
            } else {
                this.closeWhenIdle();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void closeImmediately(boolean fromIdle) {
            this.protect();
            if (this.pooled) {
                if (fromIdle) {
                    boolean callRelease = false;
                    Object object = this.onPoolRemoveCalledSync;
                    synchronized (object) {
                        if (!this.onPoolRemoveCalled) {
                            callRelease = true;
                        }
                    }
                    if (callRelease) {
                        Pool.releaseReservation(this);
                    }
                    if (this.closeEvenIfPooled) {
                        super.closeImmediately(true);
                    }
                } else {
                    boolean callRemove = false;
                    Object object = this.onPoolRemoveCalledSync;
                    synchronized (object) {
                        if (!this.onPoolRemoveCalled) {
                            this.onPoolRemoveCalled = true;
                            callRemove = true;
                        }
                    }
                    if (callRemove) {
                        Pool.removeShell(this);
                    }
                    super.closeImmediately(false);
                }
            } else {
                super.closeImmediately(fromIdle);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeWhenIdle(boolean fromPool) {
            this.protect();
            if (this.pooled) {
                Object object = this.onPoolRemoveCalledSync;
                synchronized (object) {
                    if (!this.onPoolRemoveCalled) {
                        this.onPoolRemoveCalled = true;
                        Pool.removeShell(this);
                    }
                }
                if (fromPool) {
                    this.closeEvenIfPooled = true;
                }
            }
            super.closeWhenIdle();
        }

        @Override
        @AnyThread
        public void closeWhenIdle() {
            this.closeWhenIdle(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean wasPoolRemoveCalled() {
            Object object = this.onPoolRemoveCalledSync;
            synchronized (object) {
                return this.onPoolRemoveCalled;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onClosed() {
            if (this.inClosingJoin) {
                return;
            }
            if (this.pooled) {
                boolean callRemove = false;
                Object object = this.onPoolRemoveCalledSync;
                synchronized (object) {
                    if (!this.onPoolRemoveCalled) {
                        this.onPoolRemoveCalled = true;
                        callRemove = true;
                    }
                }
                if (callRemove) {
                    this.protect();
                    Pool.removeShell(this);
                }
            }
            if (this.onCloseCalledSync == null) {
                return;
            }
            Object object = this.onCloseCalledSync;
            synchronized (object) {
                if (this.onClosedCalled) {
                    return;
                }
                this.onClosedCalled = true;
            }
            try {
                super.onClosed();
            }
            catch (Throwable throwable) {
                if (!this.handlerThread.isAlive()) {
                    this.collect();
                } else {
                    this.handler.post(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Object object = Threaded.this.callbackSync;
                            synchronized (object) {
                                if (Threaded.this.callbacks > 0) {
                                    Threaded.this.handler.postDelayed((Runnable)this, 1000L);
                                } else {
                                    Threaded.this.collect();
                                    if (Build.VERSION.SDK_INT >= 18) {
                                        Threaded.this.handlerThread.quitSafely();
                                    } else {
                                        Threaded.this.handlerThread.quit();
                                    }
                                }
                            }
                        }
                    });
                }
                throw throwable;
            }
            if (!this.handlerThread.isAlive()) {
                this.collect();
            } else {
                this.handler.post(new /* invalid duplicate definition of identical inner class */);
            }
        }

        @Nullable
        @AnyThread
        public ThreadedAutoCloseable ac() {
            if (this instanceof ThreadedAutoCloseable) {
                return (ThreadedAutoCloseable)this;
            }
            return null;
        }

        private boolean isReserved() {
            return this.reserved;
        }

        private void setReserved(boolean reserved) {
            this.reserved = reserved;
        }
    }

    public static class Interactive
    implements SyncCommands {
        @Nullable
        protected final Handler handler;
        private final boolean autoHandler;
        private final String shell;
        private boolean shellDiesOnSTDOUTERRClose;
        private final boolean wantSTDERR;
        @NonNull
        private final List<Command> commands;
        @NonNull
        private final Map<String, String> environment;
        @Nullable
        private final StreamGobbler.OnLineListener onSTDOUTLineListener;
        @Nullable
        private final StreamGobbler.OnLineListener onSTDERRLineListener;
        private int watchdogTimeout;
        @Nullable
        private Process process = null;
        @Nullable
        private DataOutputStream STDIN = null;
        @Nullable
        private StreamGobbler STDOUT = null;
        @Nullable
        private StreamGobbler STDERR = null;
        private final Object STDclosedSync = new Object();
        private boolean STDOUTclosed = false;
        private boolean STDERRclosed = false;
        @Nullable
        private ScheduledThreadPoolExecutor watchdog = null;
        private volatile boolean running = false;
        private volatile boolean lastOpening = false;
        private volatile boolean opening = false;
        private volatile boolean idle = true;
        protected volatile boolean closed = true;
        protected volatile int callbacks = 0;
        private volatile int watchdogCount;
        private volatile boolean doCloseWhenIdle = false;
        protected volatile boolean inClosingJoin = false;
        private final Object idleSync = new Object();
        protected final Object callbackSync = new Object();
        private final Object openingSync = new Object();
        private final List<String> emptyStringList = new ArrayList<String>();
        private volatile int lastExitCode = 0;
        @Nullable
        private volatile String lastMarkerSTDOUT = null;
        @Nullable
        private volatile String lastMarkerSTDERR = null;
        @Nullable
        private volatile Command command = null;
        @Nullable
        private volatile List<String> bufferSTDOUT = null;
        @Nullable
        private volatile List<String> bufferSTDERR = null;

        @AnyThread
        protected Interactive(final @NonNull Builder builder, final @Nullable OnShellOpenResultListener onShellOpenResultListener) {
            this.autoHandler = builder.autoHandler;
            this.shell = builder.shell;
            this.shellDiesOnSTDOUTERRClose = builder.shellDiesOnSTDOUTERRClose;
            this.wantSTDERR = builder.wantSTDERR;
            this.commands = builder.commands;
            this.environment = builder.environment;
            this.onSTDOUTLineListener = builder.onSTDOUTLineListener;
            this.onSTDERRLineListener = builder.onSTDERRLineListener;
            this.watchdogTimeout = builder.watchdogTimeout;
            this.handler = Looper.myLooper() != null && builder.handler == null && this.autoHandler ? new Handler() : builder.handler;
            if (onShellOpenResultListener != null || builder.detectOpen) {
                this.lastOpening = true;
                this.opening = true;
                this.watchdogTimeout = 60;
                this.commands.add(0, new Command(availableTestCommands, 0, new OnCommandResultListener2(){

                    @Override
                    public void onCommandResult(int commandCode, int exitCode, @NonNull List<String> STDOUT, @NonNull List<String> STDERR) {
                        if (exitCode == 0 && !Shell.parseAvailableResult(STDOUT, SU.isSU(Interactive.this.shell))) {
                            exitCode = -4;
                            Interactive.this.idle = true;
                            Interactive.this.closeImmediately();
                        }
                        Interactive.this.watchdogTimeout = builder.watchdogTimeout;
                        if (onShellOpenResultListener != null) {
                            if (Interactive.this.handler != null) {
                                final int fExitCode = exitCode;
                                Interactive.this.startCallback();
                                Interactive.this.handler.post(new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            onShellOpenResultListener.onOpenResult(fExitCode == 0, fExitCode);
                                        }
                                        finally {
                                            Interactive.this.endCallback();
                                        }
                                    }
                                });
                            } else {
                                onShellOpenResultListener.onOpenResult(exitCode == 0, exitCode);
                            }
                        }
                    }
                }));
            }
            if (!this.open() && onShellOpenResultListener != null) {
                if (this.handler != null) {
                    this.startCallback();
                    this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                onShellOpenResultListener.onOpenResult(false, -3);
                            }
                            finally {
                                Interactive.this.endCallback();
                            }
                        }
                    });
                } else {
                    onShellOpenResultListener.onOpenResult(false, -3);
                }
            }
        }

        protected void finalize() throws Throwable {
            if (!this.closed && Debug.getSanityChecksEnabledEffective()) {
                Debug.log("Application did not close() interactive shell");
                throw new ShellNotClosedException();
            }
            super.finalize();
        }

        @AnyThread
        public synchronized void addCommand(@NonNull Object commands) {
            this.addCommand(commands, 0, null);
        }

        @AnyThread
        public synchronized void addCommand(@NonNull Object commands, int code, @Nullable OnResult onResultListener) {
            this.commands.add(new Command(commands, code, onResultListener));
            this.runNextCommand();
        }

        private void runNextCommand() {
            this.runNextCommand(true);
        }

        private synchronized void handleWatchdog() {
            int exitCode;
            if (this.watchdog == null) {
                return;
            }
            if (this.watchdogTimeout == 0) {
                return;
            }
            if (!this.isRunning()) {
                exitCode = -2;
                Debug.log(String.format(Locale.ENGLISH, "[%s%%] SHELL_DIED", this.shell.toUpperCase(Locale.ENGLISH)));
            } else {
                if (this.watchdogCount++ < this.watchdogTimeout) {
                    return;
                }
                exitCode = -1;
                Debug.log(String.format(Locale.ENGLISH, "[%s%%] WATCHDOG_EXIT", this.shell.toUpperCase(Locale.ENGLISH)));
            }
            if (this.command != null) {
                this.postCallback(this.command, exitCode, this.bufferSTDOUT, this.bufferSTDERR, null);
            }
            this.command = null;
            this.bufferSTDOUT = null;
            this.bufferSTDERR = null;
            this.idle = true;
            this.opening = false;
            this.watchdog.shutdown();
            this.watchdog = null;
            this.kill();
        }

        private void startWatchdog() {
            if (this.watchdogTimeout == 0) {
                return;
            }
            this.watchdogCount = 0;
            this.watchdog = new ScheduledThreadPoolExecutor(1);
            this.watchdog.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    Interactive.this.handleWatchdog();
                }
            }, 1L, 1L, TimeUnit.SECONDS);
        }

        private void stopWatchdog() {
            if (this.watchdog != null) {
                this.watchdog.shutdownNow();
                this.watchdog = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runNextCommand(boolean notifyIdle) {
            Object object;
            boolean running = this.isRunning();
            if (!running || this.closed) {
                this.idle = true;
                this.opening = false;
            }
            if (running && !this.closed && this.idle && this.commands.size() > 0) {
                Command command = this.commands.get(0);
                this.commands.remove(0);
                this.bufferSTDOUT = null;
                this.bufferSTDERR = null;
                this.lastExitCode = 0;
                this.lastMarkerSTDOUT = null;
                this.lastMarkerSTDERR = null;
                if (command.commands.length > 0) {
                    if (this.STDIN != null && this.STDOUT != null) {
                        try {
                            if (command.onCommandResultListener != null) {
                                this.bufferSTDOUT = Collections.synchronizedList(new ArrayList());
                            } else if (command.onCommandResultListener2 != null) {
                                this.bufferSTDOUT = Collections.synchronizedList(new ArrayList());
                                this.bufferSTDERR = Collections.synchronizedList(new ArrayList());
                            }
                            this.idle = false;
                            this.command = command;
                            if (command.onCommandInputStreamListener != null) {
                                if (!this.STDOUT.isSuspended()) {
                                    if (Thread.currentThread().getId() == this.STDOUT.getId()) {
                                        this.STDOUT.suspendGobbling();
                                    } else {
                                        this.STDIN.write("echo inputstream\n".getBytes("UTF-8"));
                                        this.STDIN.flush();
                                        this.STDOUT.waitForSuspend();
                                    }
                                }
                            } else {
                                this.STDOUT.resumeGobbling();
                                this.startWatchdog();
                            }
                            for (String write : command.commands) {
                                Debug.logCommand(String.format(Locale.ENGLISH, "[%s+] %s", this.shell.toUpperCase(Locale.ENGLISH), write));
                                this.STDIN.write((write + "\n").getBytes("UTF-8"));
                            }
                            this.STDIN.write(("echo " + command.marker + " $?\n").getBytes("UTF-8"));
                            this.STDIN.write(("echo " + command.marker + " >&2\n").getBytes("UTF-8"));
                            this.STDIN.flush();
                            if (command.onCommandInputStreamListener != null) {
                                command.markerInputStream = new MarkerInputStream(this.STDOUT, command.marker);
                                this.postCallback(command, 0, null, null, command.markerInputStream);
                            }
                        }
                        catch (IOException iOException) {}
                    }
                } else {
                    this.runNextCommand(false);
                }
            } else if (!running || this.closed) {
                Debug.log(String.format(Locale.ENGLISH, "[%s%%] SHELL_DIED", this.shell.toUpperCase(Locale.ENGLISH)));
                while (this.commands.size() > 0) {
                    this.postCallback(this.commands.remove(0), -2, null, null, null);
                }
                this.onClosed();
            }
            if (this.idle) {
                if (running && this.doCloseWhenIdle) {
                    this.doCloseWhenIdle = false;
                    this.closeImmediately(true);
                }
                if (notifyIdle) {
                    object = this.idleSync;
                    synchronized (object) {
                        this.idleSync.notifyAll();
                    }
                }
            }
            if (this.lastOpening && !this.opening) {
                this.lastOpening = this.opening;
                object = this.openingSync;
                synchronized (object) {
                    this.openingSync.notifyAll();
                }
            }
        }

        private synchronized void processMarker() {
            if (this.command != null && this.command.marker.equals(this.lastMarkerSTDOUT) && this.command.marker.equals(this.lastMarkerSTDERR)) {
                this.postCallback(this.command, this.lastExitCode, this.bufferSTDOUT, this.bufferSTDERR, null);
                this.stopWatchdog();
                this.command = null;
                this.bufferSTDOUT = null;
                this.bufferSTDERR = null;
                this.idle = true;
                this.opening = false;
                this.runNextCommand();
            }
        }

        private synchronized void processLine(final @NonNull String line, final @Nullable Object listener, final boolean isSTDERR) {
            if (listener != null) {
                if (this.handler != null) {
                    this.startCallback();
                    this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (listener instanceof StreamGobbler.OnLineListener) {
                                    ((StreamGobbler.OnLineListener)listener).onLine(line);
                                } else if (listener instanceof OnCommandLineSTDOUT && !isSTDERR) {
                                    ((OnCommandLineSTDOUT)listener).onSTDOUT(line);
                                } else if (listener instanceof OnCommandLineSTDERR && isSTDERR) {
                                    ((OnCommandLineSTDERR)listener).onSTDERR(line);
                                }
                            }
                            finally {
                                Interactive.this.endCallback();
                            }
                        }
                    });
                } else if (listener instanceof StreamGobbler.OnLineListener) {
                    ((StreamGobbler.OnLineListener)listener).onLine(line);
                } else if (listener instanceof OnCommandLineSTDOUT && !isSTDERR) {
                    ((OnCommandLineSTDOUT)listener).onSTDOUT(line);
                } else if (listener instanceof OnCommandLineSTDERR && isSTDERR) {
                    ((OnCommandLineSTDERR)listener).onSTDERR(line);
                }
            }
        }

        private synchronized void addBuffer(@NonNull String line, boolean isSTDERR) {
            if (isSTDERR) {
                if (this.bufferSTDERR != null) {
                    this.bufferSTDERR.add(line);
                } else if (this.wantSTDERR && this.bufferSTDOUT != null) {
                    this.bufferSTDOUT.add(line);
                }
            } else if (this.bufferSTDOUT != null) {
                this.bufferSTDOUT.add(line);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void startCallback() {
            Object object = this.callbackSync;
            synchronized (object) {
                ++this.callbacks;
            }
        }

        private boolean postCallback(final @NonNull Command fCommand, final int fExitCode, final @Nullable List<String> fSTDOUT, final @Nullable List<String> fSTDERR, final @Nullable InputStream inputStream) {
            if (fCommand.onCommandResultListener == null && fCommand.onCommandResultListener2 == null && fCommand.onCommandLineListener == null && fCommand.onCommandInputStreamListener == null) {
                return true;
            }
            if (this.handler == null || fCommand.commands == availableTestCommands) {
                if (inputStream == null) {
                    if (fCommand.onCommandResultListener != null) {
                        fCommand.onCommandResultListener.onCommandResult(fCommand.code, fExitCode, fSTDOUT != null ? fSTDOUT : this.emptyStringList);
                    }
                    if (fCommand.onCommandResultListener2 != null) {
                        fCommand.onCommandResultListener2.onCommandResult(fCommand.code, fExitCode, fSTDOUT != null ? fSTDOUT : this.emptyStringList, fSTDERR != null ? fSTDERR : this.emptyStringList);
                    }
                    if (fCommand.onCommandLineListener != null) {
                        fCommand.onCommandLineListener.onCommandResult(fCommand.code, fExitCode);
                    }
                    if (fCommand.onCommandInputStreamListener != null) {
                        fCommand.onCommandInputStreamListener.onCommandResult(fCommand.code, fExitCode);
                    }
                } else if (fCommand.onCommandInputStreamListener != null) {
                    fCommand.onCommandInputStreamListener.onInputStream(inputStream);
                }
                return true;
            }
            this.startCallback();
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (inputStream == null) {
                            if (fCommand.onCommandResultListener != null) {
                                fCommand.onCommandResultListener.onCommandResult(fCommand.code, fExitCode, fSTDOUT != null ? fSTDOUT : Interactive.this.emptyStringList);
                            }
                            if (fCommand.onCommandResultListener2 != null) {
                                fCommand.onCommandResultListener2.onCommandResult(fCommand.code, fExitCode, fSTDOUT != null ? fSTDOUT : Interactive.this.emptyStringList, fSTDERR != null ? fSTDERR : Interactive.this.emptyStringList);
                            }
                            if (fCommand.onCommandLineListener != null) {
                                fCommand.onCommandLineListener.onCommandResult(fCommand.code, fExitCode);
                            }
                            if (fCommand.onCommandInputStreamListener != null) {
                                fCommand.onCommandInputStreamListener.onCommandResult(fCommand.code, fExitCode);
                            }
                        } else if (fCommand.onCommandInputStreamListener != null) {
                            fCommand.onCommandInputStreamListener.onInputStream(inputStream);
                        }
                    }
                    finally {
                        Interactive.this.endCallback();
                    }
                }
            });
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void endCallback() {
            Object object = this.callbackSync;
            synchronized (object) {
                --this.callbacks;
                if (this.callbacks == 0) {
                    this.callbackSync.notifyAll();
                }
            }
        }

        private synchronized boolean open() {
            Debug.log(String.format(Locale.ENGLISH, "[%s%%] START", this.shell.toUpperCase(Locale.ENGLISH)));
            try {
                if (this.environment.size() == 0) {
                    this.process = Runtime.getRuntime().exec(this.shell);
                } else {
                    HashMap<String, String> newEnvironment = new HashMap<String, String>();
                    newEnvironment.putAll(System.getenv());
                    newEnvironment.putAll(this.environment);
                    int i = 0;
                    String[] env = new String[newEnvironment.size()];
                    for (Map.Entry entry : newEnvironment.entrySet()) {
                        env[i] = (String)entry.getKey() + "=" + (String)entry.getValue();
                        ++i;
                    }
                    this.process = Runtime.getRuntime().exec(this.shell, env);
                }
                if (this.process == null) {
                    throw new NullPointerException();
                }
                StreamGobbler.OnStreamClosedListener onStreamClosedListener = new StreamGobbler.OnStreamClosedListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onStreamClosed() {
                        if (Interactive.this.shellDiesOnSTDOUTERRClose || !Interactive.this.isRunning()) {
                            boolean isLast;
                            if (Interactive.this.STDERR != null && Thread.currentThread() == Interactive.this.STDOUT) {
                                Interactive.this.STDERR.resumeGobbling();
                            }
                            if (Interactive.this.STDOUT != null && Thread.currentThread() == Interactive.this.STDERR) {
                                Interactive.this.STDOUT.resumeGobbling();
                            }
                            Object object = Interactive.this.STDclosedSync;
                            synchronized (object) {
                                MarkerInputStream mis;
                                if (Thread.currentThread() == Interactive.this.STDOUT) {
                                    Interactive.this.STDOUTclosed = true;
                                }
                                if (Thread.currentThread() == Interactive.this.STDERR) {
                                    Interactive.this.STDERRclosed = true;
                                }
                                isLast = Interactive.this.STDOUTclosed && Interactive.this.STDERRclosed;
                                Command c = Interactive.this.command;
                                if (c != null && (mis = c.markerInputStream) != null) {
                                    mis.setEOF();
                                }
                            }
                            if (isLast) {
                                Interactive.this.waitForCallbacks();
                                object = Interactive.this;
                                synchronized (object) {
                                    if (Interactive.this.command != null) {
                                        Interactive.this.postCallback(Interactive.this.command, -2, Interactive.this.bufferSTDOUT, Interactive.this.bufferSTDERR, null);
                                        Interactive.this.command = null;
                                    }
                                    Interactive.this.closed = true;
                                    Interactive.this.opening = false;
                                    Interactive.this.runNextCommand();
                                }
                            }
                        }
                    }
                };
                this.STDIN = new DataOutputStream(this.process.getOutputStream());
                this.STDOUT = new StreamGobbler(this.shell.toUpperCase(Locale.ENGLISH) + "-", this.process.getInputStream(), new StreamGobbler.OnLineListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onLine(@NonNull String line) {
                        Command cmd = Interactive.this.command;
                        if (cmd != null && cmd.onCommandInputStreamListener != null && line.equals("inputstream")) {
                            if (Interactive.this.STDOUT != null) {
                                Interactive.this.STDOUT.suspendGobbling();
                            }
                            return;
                        }
                        Interactive interactive = Interactive.this;
                        synchronized (interactive) {
                            if (Interactive.this.command == null) {
                                return;
                            }
                            String contentPart = line;
                            String markerPart = null;
                            int markerIndex = line.indexOf(Interactive.this.command.marker);
                            if (markerIndex == 0) {
                                contentPart = null;
                                markerPart = line;
                            } else if (markerIndex > 0) {
                                contentPart = line.substring(0, markerIndex);
                                markerPart = line.substring(markerIndex);
                            }
                            if (contentPart != null) {
                                Interactive.this.addBuffer(contentPart, false);
                                Interactive.this.processLine(contentPart, Interactive.this.onSTDOUTLineListener, false);
                                Interactive.this.processLine(contentPart, Interactive.this.command.onCommandLineListener, false);
                            }
                            if (markerPart != null) {
                                try {
                                    Interactive.this.lastExitCode = Integer.valueOf(markerPart.substring(Interactive.this.command.marker.length() + 1), 10);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                Interactive.this.lastMarkerSTDOUT = Interactive.this.command.marker;
                                Interactive.this.processMarker();
                            }
                        }
                    }
                }, onStreamClosedListener);
                this.STDERR = new StreamGobbler(this.shell.toUpperCase(Locale.ENGLISH) + "*", this.process.getErrorStream(), new StreamGobbler.OnLineListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onLine(@NonNull String line) {
                        Interactive interactive = Interactive.this;
                        synchronized (interactive) {
                            if (Interactive.this.command == null) {
                                return;
                            }
                            String contentPart = line;
                            int markerIndex = line.indexOf(Interactive.this.command.marker);
                            if (markerIndex == 0) {
                                contentPart = null;
                            } else if (markerIndex > 0) {
                                contentPart = line.substring(0, markerIndex);
                            }
                            if (contentPart != null) {
                                Interactive.this.addBuffer(contentPart, true);
                                Interactive.this.processLine(contentPart, Interactive.this.onSTDERRLineListener, true);
                                Interactive.this.processLine(contentPart, Interactive.this.command.onCommandLineListener, true);
                                Interactive.this.processLine(contentPart, Interactive.this.command.onCommandInputStreamListener, true);
                            }
                            if (markerIndex >= 0) {
                                Interactive.this.lastMarkerSTDERR = Interactive.this.command.marker;
                                Interactive.this.processMarker();
                            }
                        }
                    }
                }, onStreamClosedListener);
                this.STDOUT.start();
                this.STDERR.start();
                this.running = true;
                this.closed = false;
                this.runNextCommand();
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }

        protected void onClosed() {
        }

        @WorkerThread
        public void close() {
            this.closeImmediately();
        }

        @WorkerThread
        public void closeImmediately() {
            this.closeImmediately(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void closeImmediately(boolean fromIdle) {
            if (this.STDIN == null || this.STDOUT == null || this.STDERR == null || this.process == null) {
                throw new NullPointerException();
            }
            boolean _idle = this.isIdle();
            Interactive interactive = this;
            synchronized (interactive) {
                if (!this.running) {
                    return;
                }
                this.running = false;
                this.closed = true;
            }
            if (!this.isRunning()) {
                this.onClosed();
                return;
            }
            if (!_idle && Debug.getSanityChecksEnabledEffective() && Debug.onMainThread()) {
                Debug.log("Application attempted to wait for a non-idle shell to close on the main thread");
                throw new ShellOnMainThreadException("Application attempted to wait for a non-idle shell to close on the main thread");
            }
            if (!_idle) {
                this.waitForIdle();
            }
            try {
                block18: {
                    try {
                        this.STDIN.write("exit\n".getBytes("UTF-8"));
                        this.STDIN.flush();
                    }
                    catch (IOException e) {
                        if (e.getMessage().contains("EPIPE") || e.getMessage().contains("Stream closed")) break block18;
                        throw e;
                    }
                }
                this.process.waitFor();
                try {
                    this.STDIN.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (Thread.currentThread() != this.STDOUT) {
                    this.STDOUT.resumeGobbling();
                }
                if (Thread.currentThread() != this.STDERR) {
                    this.STDERR.resumeGobbling();
                }
                if (Thread.currentThread() != this.STDOUT && Thread.currentThread() != this.STDERR) {
                    this.inClosingJoin = true;
                    this.STDOUT.conditionalJoin();
                    this.STDERR.conditionalJoin();
                    this.inClosingJoin = false;
                }
                this.stopWatchdog();
                this.process.destroy();
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Debug.log(String.format(Locale.ENGLISH, "[%s%%] END", this.shell.toUpperCase(Locale.ENGLISH)));
            this.onClosed();
        }

        @AnyThread
        public void closeWhenIdle() {
            if (this.idle) {
                this.closeImmediately(true);
            } else {
                this.doCloseWhenIdle = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        public synchronized void kill() {
            if (this.STDIN == null || this.process == null) {
                throw new NullPointerException();
            }
            this.running = false;
            this.closed = true;
            try {
                this.STDIN.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.process.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.idle = true;
            this.opening = false;
            Object object = this.idleSync;
            synchronized (object) {
                this.idleSync.notifyAll();
            }
            if (this.lastOpening && !this.opening) {
                this.lastOpening = this.opening;
                object = this.openingSync;
                synchronized (object) {
                    this.openingSync.notifyAll();
                }
            }
            this.onClosed();
        }

        @AnyThread
        public boolean isOpening() {
            return this.isRunning() && this.opening;
        }

        @AnyThread
        public boolean isRunning() {
            if (this.process == null) {
                return false;
            }
            try {
                this.process.exitValue();
                return false;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @AnyThread
        public synchronized boolean isIdle() {
            if (!this.isRunning()) {
                this.idle = true;
                this.opening = false;
                Object object = this.idleSync;
                synchronized (object) {
                    this.idleSync.notifyAll();
                }
                if (this.lastOpening && !this.opening) {
                    this.lastOpening = this.opening;
                    object = this.openingSync;
                    synchronized (object) {
                        this.openingSync.notifyAll();
                    }
                }
            }
            return this.idle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean waitForCallbacks() {
            if (this.handler != null && this.handler.getLooper() != null && this.handler.getLooper() != Looper.myLooper()) {
                Object object = this.callbackSync;
                synchronized (object) {
                    while (this.callbacks > 0) {
                        try {
                            this.callbackSync.wait();
                        }
                        catch (InterruptedException e) {
                            return false;
                        }
                    }
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        public boolean waitForIdle() {
            if (Debug.getSanityChecksEnabledEffective() && Debug.onMainThread()) {
                Debug.log("Application attempted to wait for a shell to become idle on the main thread");
                throw new ShellOnMainThreadException("Application attempted to wait for a shell to become idle on the main thread");
            }
            if (this.isRunning()) {
                Object object = this.idleSync;
                synchronized (object) {
                    while (!this.idle) {
                        try {
                            this.idleSync.wait();
                        }
                        catch (InterruptedException e) {
                            return false;
                        }
                    }
                }
                return this.waitForCallbacks();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        public boolean waitForOpened(@Nullable Boolean defaultIfInterrupted) {
            if (Debug.getSanityChecksEnabledEffective() && Debug.onMainThread()) {
                Debug.log("Application attempted to wait for a shell to become idle on the main thread");
                throw new ShellOnMainThreadException("Application attempted to wait for a shell to become idle on the main thread");
            }
            if (this.isRunning()) {
                Object object = this.openingSync;
                synchronized (object) {
                    while (this.opening) {
                        try {
                            this.openingSync.wait();
                        }
                        catch (InterruptedException e) {
                            if (defaultIfInterrupted == null) continue;
                            return defaultIfInterrupted;
                        }
                    }
                }
            }
            return this.isRunning();
        }

        @AnyThread
        public boolean hasHandler() {
            return this.handler != null;
        }

        @AnyThread
        public boolean hasCommands() {
            return this.commands.size() > 0;
        }

        @Override
        @WorkerThread
        public int run(@NonNull Object commands) throws ShellDiedException {
            return this.run(commands, null, null, false);
        }

        @Override
        @WorkerThread
        public int run(@NonNull Object commands, final @Nullable List<String> STDOUT, final @Nullable List<String> STDERR, boolean clear) throws ShellDiedException {
            if (clear) {
                if (STDOUT != null) {
                    STDOUT.clear();
                }
                if (STDERR != null) {
                    STDERR.clear();
                }
            }
            final int[] exitCode = new int[1];
            this.addCommand(commands, 0, new OnCommandResultListener2(){

                @Override
                public void onCommandResult(int commandCode, int intExitCode, @NonNull List<String> intSTDOUT, @NonNull List<String> intSTDERR) {
                    exitCode[0] = intExitCode;
                    if (STDOUT != null) {
                        STDOUT.addAll(intSTDOUT);
                    }
                    if (STDERR != null) {
                        STDERR.addAll(intSTDERR);
                    }
                }
            });
            this.waitForIdle();
            if (exitCode[0] < 0) {
                throw new ShellDiedException();
            }
            return exitCode[0];
        }

        @Override
        @WorkerThread
        public int run(@NonNull Object commands, final @NonNull OnSyncCommandLineListener onSyncCommandLineListener) throws ShellDiedException {
            final int[] exitCode = new int[1];
            this.addCommand(commands, 0, new OnCommandLineListener(){

                @Override
                public void onSTDERR(@NonNull String line) {
                    onSyncCommandLineListener.onSTDERR(line);
                }

                @Override
                public void onSTDOUT(@NonNull String line) {
                    onSyncCommandLineListener.onSTDOUT(line);
                }

                @Override
                public void onCommandResult(int commandCode, int intExitCode) {
                    exitCode[0] = intExitCode;
                }
            });
            this.waitForIdle();
            if (exitCode[0] < 0) {
                throw new ShellDiedException();
            }
            return exitCode[0];
        }

        @Override
        @WorkerThread
        public int run(@NonNull Object commands, final @NonNull OnSyncCommandInputStreamListener onSyncCommandInputStreamListener) throws ShellDiedException {
            final int[] exitCode = new int[1];
            this.addCommand(commands, 0, new OnCommandInputStreamListener(){

                @Override
                public void onSTDERR(@NonNull String line) {
                    onSyncCommandInputStreamListener.onSTDERR(line);
                }

                @Override
                public void onInputStream(@NonNull InputStream inputStream) {
                    onSyncCommandInputStreamListener.onInputStream(inputStream);
                }

                @Override
                public void onCommandResult(int commandCode, int intExitCode) {
                    exitCode[0] = intExitCode;
                }
            });
            this.waitForIdle();
            if (exitCode[0] < 0) {
                throw new ShellDiedException();
            }
            return exitCode[0];
        }
    }

    @WorkerThread
    public static interface SyncCommands {
        public int run(@NonNull Object var1) throws ShellDiedException;

        public int run(@NonNull Object var1, @Nullable List<String> var2, @Nullable List<String> var3, boolean var4) throws ShellDiedException;

        public int run(@NonNull Object var1, @NonNull OnSyncCommandLineListener var2) throws ShellDiedException;

        public int run(@NonNull Object var1, @NonNull OnSyncCommandInputStreamListener var2) throws ShellDiedException;
    }

    @Deprecated
    @WorkerThread
    public static interface DeprecatedSyncCommands {
        @Deprecated
        @Nullable
        public List<String> run(@NonNull Object var1, boolean var2);

        @Deprecated
        @Nullable
        public List<String> run(@NonNull Object var1, @Nullable String[] var2, boolean var3);
    }

    public static interface OnSyncCommandInputStreamListener
    extends OnCommandInputStream,
    OnCommandLineSTDERR {
    }

    public static interface OnSyncCommandLineListener
    extends OnCommandLineSTDOUT,
    OnCommandLineSTDERR {
    }

    @AnyThread
    public static class Builder {
        @Nullable
        private Handler handler = null;
        private boolean autoHandler = true;
        private String shell = "sh";
        private boolean wantSTDERR = false;
        private boolean shellDiesOnSTDOUTERRClose = true;
        private boolean detectOpen = true;
        @NonNull
        private List<Command> commands = new LinkedList<Command>();
        @NonNull
        private Map<String, String> environment = new HashMap<String, String>();
        @Nullable
        private StreamGobbler.OnLineListener onSTDOUTLineListener = null;
        @Nullable
        private StreamGobbler.OnLineListener onSTDERRLineListener = null;
        private int watchdogTimeout = 0;

        @NonNull
        public Builder setHandler(@Nullable Handler handler) {
            this.handler = handler;
            return this;
        }

        @NonNull
        public Builder setAutoHandler(boolean autoHandler) {
            this.autoHandler = autoHandler;
            return this;
        }

        @NonNull
        public Builder setShell(@NonNull String shell) {
            this.shell = shell;
            return this;
        }

        @NonNull
        public Builder useSH() {
            return this.setShell("sh");
        }

        @NonNull
        public Builder useSU() {
            return this.setShell("su");
        }

        @Deprecated
        @NonNull
        public Builder setDetectOpen(boolean detectOpen) {
            this.detectOpen = detectOpen;
            return this;
        }

        @Deprecated
        @NonNull
        public Builder setShellDiesOnSTDOUTERRClose(boolean shellDies) {
            this.shellDiesOnSTDOUTERRClose = shellDies;
            return this;
        }

        @Deprecated
        @NonNull
        public Builder setWantSTDERR(boolean wantSTDERR) {
            this.wantSTDERR = wantSTDERR;
            return this;
        }

        @NonNull
        public Builder addEnvironment(@NonNull String key, @NonNull String value) {
            this.environment.put(key, value);
            return this;
        }

        @NonNull
        public Builder addEnvironment(@NonNull Map<String, String> addEnvironment) {
            this.environment.putAll(addEnvironment);
            return this;
        }

        @NonNull
        public Builder addCommand(@NonNull Object commands) {
            return this.addCommand(commands, 0, null);
        }

        @NonNull
        public Builder addCommand(@NonNull Object commands, int code, @Nullable OnResult onResultListener) {
            this.commands.add(new Command(commands, code, onResultListener));
            return this;
        }

        @NonNull
        public Builder setOnSTDOUTLineListener(@Nullable StreamGobbler.OnLineListener onLineListener) {
            this.onSTDOUTLineListener = onLineListener;
            return this;
        }

        @NonNull
        public Builder setOnSTDERRLineListener(@Nullable StreamGobbler.OnLineListener onLineListener) {
            this.onSTDERRLineListener = onLineListener;
            return this;
        }

        @NonNull
        public Builder setWatchdogTimeout(int watchdogTimeout) {
            this.watchdogTimeout = watchdogTimeout;
            return this;
        }

        @NonNull
        public Builder setMinimalLogging(boolean useMinimal) {
            Debug.setLogTypeEnabled(6, !useMinimal);
            return this;
        }

        @NonNull
        public Interactive open() {
            return new Interactive(this, null);
        }

        @NonNull
        public Interactive open(@Nullable OnShellOpenResultListener onShellOpenResultListener) {
            return new Interactive(this, onShellOpenResultListener);
        }

        @NonNull
        public Threaded openThreaded() {
            return this.openThreadedEx(null, false);
        }

        @NonNull
        public Threaded openThreaded(@Nullable OnShellOpenResultListener onShellOpenResultListener) {
            return this.openThreadedEx(onShellOpenResultListener, false);
        }

        private Threaded openThreadedEx(OnShellOpenResultListener onShellOpenResultListener, boolean pooled) {
            if (Build.VERSION.SDK_INT >= 19) {
                return new ThreadedAutoCloseable(this, onShellOpenResultListener, pooled);
            }
            return new Threaded(this, onShellOpenResultListener, pooled);
        }
    }

    private static class Command {
        private static int commandCounter = 0;
        private final String[] commands;
        private final int code;
        @Nullable
        private final OnCommandResultListener onCommandResultListener;
        @Nullable
        private final OnCommandResultListener2 onCommandResultListener2;
        @Nullable
        private final OnCommandLineListener onCommandLineListener;
        @Nullable
        private final OnCommandInputStreamListener onCommandInputStreamListener;
        @NonNull
        private final String marker;
        @Nullable
        private volatile MarkerInputStream markerInputStream = null;

        public Command(@NonNull Object commands, int code, @Nullable OnResult listener) {
            if (commands instanceof String) {
                this.commands = new String[]{(String)commands};
            } else if (commands instanceof List) {
                this.commands = ((List)commands).toArray(new String[0]);
            } else if (commands instanceof String[]) {
                this.commands = (String[])commands;
            } else {
                throw new IllegalArgumentException("commands parameter must be of type String, List<String> or String[]");
            }
            this.code = code;
            this.marker = UUID.randomUUID().toString() + String.format(Locale.ENGLISH, "-%08x", ++commandCounter);
            OnCommandResultListener commandResultListener = null;
            OnCommandResultListener2 commandResultListener2 = null;
            OnCommandLineListener commandLineListener = null;
            OnCommandInputStreamListener commandInputStreamListener = null;
            if (listener != null) {
                if (listener instanceof OnCommandInputStreamListener) {
                    commandInputStreamListener = (OnCommandInputStreamListener)listener;
                } else if (listener instanceof OnCommandLineListener) {
                    commandLineListener = (OnCommandLineListener)listener;
                } else if (listener instanceof OnCommandResultListener2) {
                    commandResultListener2 = (OnCommandResultListener2)listener;
                } else if (listener instanceof OnCommandResultListener) {
                    commandResultListener = (OnCommandResultListener)listener;
                } else {
                    throw new IllegalArgumentException("OnResult is not a supported callback interface");
                }
            }
            this.onCommandResultListener = commandResultListener;
            this.onCommandResultListener2 = commandResultListener2;
            this.onCommandLineListener = commandLineListener;
            this.onCommandInputStreamListener = commandInputStreamListener;
        }
    }

    public static interface OnCommandInputStreamListener
    extends OnCommandResultListenerUnbuffered,
    OnCommandInputStream {
    }

    public static interface OnCommandInputStream
    extends OnCommandLineSTDERR {
        public void onInputStream(@NonNull InputStream var1);
    }

    public static interface OnCommandLineListener
    extends OnCommandResultListenerUnbuffered,
    OnCommandLineSTDOUT,
    OnCommandLineSTDERR {
    }

    private static interface OnCommandLineSTDERR {
        public void onSTDERR(@NonNull String var1);
    }

    private static interface OnCommandLineSTDOUT {
        public void onSTDOUT(@NonNull String var1);
    }

    private static interface OnCommandResultListenerUnbuffered
    extends OnResult {
        public void onCommandResult(int var1, int var2);
    }

    public static interface OnCommandResultListener2
    extends OnResult {
        public void onCommandResult(int var1, int var2, @NonNull List<String> var3, @NonNull List<String> var4);
    }

    @Deprecated
    public static interface OnCommandResultListener
    extends OnResult {
        public void onCommandResult(int var1, int var2, @NonNull List<String> var3);
    }

    public static interface OnShellOpenResultListener
    extends OnResult {
        public void onOpenResult(boolean var1, int var2);
    }

    public static interface OnResult {
        public static final int WATCHDOG_EXIT = -1;
        public static final int SHELL_DIED = -2;
        public static final int SHELL_EXEC_FAILED = -3;
        public static final int SHELL_WRONG_UID = -4;
        public static final int SHELL_RUNNING = 0;
    }

    public static class SU {
        @Nullable
        private static Boolean isSELinuxEnforcing = null;
        @NonNull
        private static String[] suVersion = new String[]{null, null};

        @Deprecated
        @Nullable
        @WorkerThread
        public static List<String> run(@NonNull String command) {
            return Shell.run("su", new String[]{command}, null, false);
        }

        @Deprecated
        @Nullable
        @WorkerThread
        public static List<String> run(@NonNull List<String> commands) {
            return Shell.run("su", commands.toArray(new String[0]), null, false);
        }

        @Deprecated
        @Nullable
        @WorkerThread
        public static List<String> run(@NonNull String[] commands) {
            return Shell.run("su", commands, null, false);
        }

        @WorkerThread
        public static boolean available() {
            List<String> ret = SU.run(availableTestCommands);
            return Shell.parseAvailableResult(ret, true);
        }

        @Nullable
        @WorkerThread
        public static synchronized String version(boolean internal) {
            int idx;
            int n = idx = internal ? 0 : 1;
            if (suVersion[idx] == null) {
                ArrayList<String> ret;
                String version = null;
                if (!redirectDeprecated) {
                    ret = Shell.run(internal ? "su -V" : "su -v", new String[]{"exit"}, null, false);
                } else {
                    ret = new ArrayList();
                    try {
                        ret = new ArrayList();
                        Pool.SH.run(new String[]{internal ? "su -V" : "su -v", "exit"}, ret, null, false);
                    }
                    catch (ShellDiedException shellDiedException) {
                        // empty catch block
                    }
                }
                if (ret != null) {
                    for (String line : ret) {
                        if (!internal) {
                            if (line.trim().equals("")) continue;
                            version = line;
                            break;
                        }
                        try {
                            if (Integer.parseInt(line) <= 0) continue;
                            version = line;
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                        }
                    }
                }
                SU.suVersion[idx] = version;
            }
            return suVersion[idx];
        }

        @AnyThread
        public static boolean isSU(String shell) {
            int pos = shell.indexOf(32);
            if (pos >= 0) {
                shell = shell.substring(0, pos);
            }
            if ((pos = shell.lastIndexOf(47)) >= 0) {
                shell = shell.substring(pos + 1);
            }
            return shell.toLowerCase(Locale.ENGLISH).equals("su");
        }

        @NonNull
        @WorkerThread
        public static String shell(int uid, @Nullable String context) {
            String shell = "su";
            if (context != null && SU.isSELinuxEnforcing()) {
                String display = SU.version(false);
                String internal = SU.version(true);
                if (display != null && internal != null && display.endsWith("SUPERSU") && Integer.valueOf(internal) >= 190) {
                    shell = String.format(Locale.ENGLISH, "%s --context %s", shell, context);
                }
            }
            if (uid > 0) {
                shell = String.format(Locale.ENGLISH, "%s %d", shell, uid);
            }
            return shell;
        }

        @NonNull
        @AnyThread
        public static String shellMountMaster() {
            if (Build.VERSION.SDK_INT >= 17) {
                return "su --mount-master";
            }
            return "su";
        }

        @SuppressLint(value={"PrivateApi"})
        @WorkerThread
        public static synchronized boolean isSELinuxEnforcing() {
            if (isSELinuxEnforcing == null) {
                Boolean enforcing = null;
                if (Build.VERSION.SDK_INT >= 17) {
                    File f;
                    if (Build.VERSION.SDK_INT >= 28) {
                        enforcing = true;
                    }
                    if (enforcing == null && (f = new File("/sys/fs/selinux/enforce")).exists()) {
                        try (FileInputStream is2 = new FileInputStream("/sys/fs/selinux/enforce");){
                            enforcing = ((InputStream)is2).read() == 49;
                        }
                        catch (Exception is2) {
                            // empty catch block
                        }
                    }
                    if (enforcing == null) {
                        try {
                            Class<?> seLinux = Class.forName("android.os.SELinux");
                            Method isSELinuxEnforced = seLinux.getMethod("isSELinuxEnforced", new Class[0]);
                            enforcing = (Boolean)isSELinuxEnforced.invoke(seLinux.newInstance(), new Object[0]);
                        }
                        catch (Exception e) {
                            enforcing = Build.VERSION.SDK_INT >= 19;
                        }
                    }
                }
                if (enforcing == null) {
                    enforcing = false;
                }
                isSELinuxEnforcing = enforcing;
            }
            return isSELinuxEnforcing;
        }

        @AnyThread
        public static synchronized void clearCachedResults() {
            isSELinuxEnforcing = null;
            SU.suVersion[0] = null;
            SU.suVersion[1] = null;
        }
    }

    public static class SH {
        @Deprecated
        @Nullable
        @WorkerThread
        public static List<String> run(@NonNull String command) {
            return Shell.run("sh", new String[]{command}, null, false);
        }

        @Deprecated
        @Nullable
        @WorkerThread
        public static List<String> run(@NonNull List<String> commands) {
            return Shell.run("sh", commands.toArray(new String[0]), null, false);
        }

        @Deprecated
        @Nullable
        @WorkerThread
        public static List<String> run(@NonNull String[] commands) {
            return Shell.run("sh", commands, null, false);
        }
    }

    public static class ShellDiedException
    extends Exception {
        public static final String EXCEPTION_SHELL_DIED = "Shell died (or access was not granted)";

        public ShellDiedException() {
            super(EXCEPTION_SHELL_DIED);
        }
    }

    public static class ShellNotClosedException
    extends RuntimeException {
        public static final String EXCEPTION_NOT_CLOSED = "Application did not close() interactive shell";

        public ShellNotClosedException() {
            super(EXCEPTION_NOT_CLOSED);
        }
    }

    public static class ShellOnMainThreadException
    extends RuntimeException {
        public static final String EXCEPTION_COMMAND = "Application attempted to run a shell command from the main thread";
        public static final String EXCEPTION_NOT_IDLE = "Application attempted to wait for a non-idle shell to close on the main thread";
        public static final String EXCEPTION_WAIT_IDLE = "Application attempted to wait for a shell to become idle on the main thread";
        public static final String EXCEPTION_TOOLBOX = "Application attempted to init the Toolbox class from the main thread";

        public ShellOnMainThreadException(String message) {
            super(message);
        }
    }
}

