/*
 * Decompiled with CFR 0.152.
 */
package eu.chainfire.libsuperuser;

import androidx.annotation.AnyThread;
import androidx.annotation.NonNull;
import eu.chainfire.libsuperuser.StreamGobbler;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

@AnyThread
public class MarkerInputStream
extends InputStream {
    private static final String EXCEPTION_EOF = "EOF encountered, shell probably died";
    @NonNull
    private final StreamGobbler gobbler;
    private final InputStream inputStream;
    private final byte[] marker;
    private final int markerLength;
    private final int markerMaxLength;
    private final byte[] read1 = new byte[1];
    private final byte[] buffer = new byte[65536];
    private int bufferUsed = 0;
    private volatile boolean eof = false;
    private volatile boolean done = false;

    public MarkerInputStream(@NonNull StreamGobbler gobbler, @NonNull String marker) throws UnsupportedEncodingException {
        this.gobbler = gobbler;
        this.gobbler.suspendGobbling();
        this.inputStream = gobbler.getInputStream();
        this.marker = marker.getBytes("UTF-8");
        this.markerLength = marker.length();
        this.markerMaxLength = marker.length() + 5;
    }

    @Override
    public int read() throws IOException {
        while (true) {
            int r;
            if ((r = this.read(this.read1, 0, 1)) < 0) {
                return -1;
            }
            if (r != 0) break;
            try {
                Thread.sleep(16L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.read1[0] & 0xFF;
    }

    @Override
    public int read(@NonNull byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    private void fill(int safeSizeToWaitFor) {
        if (this.isEOF()) {
            return;
        }
        try {
            int a;
            while ((a = this.inputStream.available()) > 0 || safeSizeToWaitFor > 0) {
                int left = this.buffer.length - this.bufferUsed;
                if (left == 0) {
                    return;
                }
                int r = this.inputStream.read(this.buffer, this.bufferUsed, Math.max(safeSizeToWaitFor, Math.min(a, left)));
                if (r >= 0) {
                    this.bufferUsed += r;
                    safeSizeToWaitFor -= r;
                    continue;
                }
                this.setEOF();
                break;
            }
        }
        catch (IOException e) {
            this.setEOF();
        }
    }

    @Override
    public synchronized int read(@NonNull byte[] b, int off, int len) throws IOException {
        int ret;
        if (this.done) {
            return -1;
        }
        this.fill(this.markerLength - this.bufferUsed);
        if (this.bufferUsed < this.markerLength) {
            return 0;
        }
        int match = -1;
        for (int i = Math.max(0, this.bufferUsed - this.markerMaxLength); i < this.bufferUsed - this.markerLength; ++i) {
            boolean found = true;
            for (int j = 0; j < this.markerLength; ++j) {
                if (this.buffer[i + j] == this.marker[j]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            match = i;
            break;
        }
        if (match == 0) {
            while (this.buffer[this.bufferUsed - 1] != 10) {
                if (this.isEOF()) {
                    throw new IOException(EXCEPTION_EOF);
                }
                this.fill(1);
            }
            if (this.gobbler.getOnLineListener() != null) {
                this.gobbler.getOnLineListener().onLine(new String(this.buffer, 0, this.bufferUsed - 1, "UTF-8"));
            }
            this.done = true;
            return -1;
        }
        if (match == -1) {
            if (this.isEOF()) {
                throw new IOException(EXCEPTION_EOF);
            }
            ret = Math.min(len, this.bufferUsed - this.markerMaxLength);
        } else {
            ret = Math.min(len, match);
        }
        if (ret > 0) {
            System.arraycopy(this.buffer, 0, b, off, ret);
            this.bufferUsed -= ret;
            System.arraycopy(this.buffer, ret, this.buffer, 0, this.bufferUsed);
        } else {
            try {
                Thread.sleep(4L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.isEOF() && !this.done) {
            byte[] buffer = new byte[1024];
            while (this.read(buffer) >= 0) {
            }
        }
    }

    public synchronized boolean isEOF() {
        return this.eof;
    }

    public synchronized void setEOF() {
        this.eof = true;
    }
}

