/*
 * Decompiled with CFR 0.152.
 */
package eu.cedarsoft.wicket.breadcrumb;

import eu.cedarsoft.commons.struct.ChildNotFoundException;
import eu.cedarsoft.commons.struct.Node;
import eu.cedarsoft.commons.struct.Path;
import eu.cedarsoft.commons.struct.Route;
import java.util.ArrayDeque;
import org.apache.wicket.Page;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageStructure {
    private Node rootNode;

    public PageStructure(@NotNull Node rootNode) {
        this.rootNode = rootNode;
    }

    @NotNull
    public Node getRootNode() {
        return this.rootNode;
    }

    @NotNull
    public Node findNode(@NotNull Class<? extends Page> pageClass) {
        ArrayDeque<Node> queue = new ArrayDeque<Node>();
        queue.add(this.rootNode);
        while (!queue.isEmpty()) {
            Node current = (Node)queue.poll();
            if (pageClass.equals(current.getLookup().lookup(Class.class))) {
                return current;
            }
            queue.addAll(current.getChildren());
        }
        throw new IllegalArgumentException("No Node found for " + pageClass);
    }

    @NotNull
    public Route getRoute(@NotNull Path path) throws ChildNotFoundException {
        return Route.buildRoute((Node)this.getRootNode(), (Path)path);
    }

    @NotNull
    public Route findRoute(@NotNull Class<? extends Page> pageClass) {
        return this.getRoute(this.findNode(pageClass).getPath());
    }
}

