package eu.cedarsoft.wicket.contact;

import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.CompoundPropertyModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

import java.io.Serializable;

/**
 * The contact form.
 */
public class ContactForm extends Form {
  public ContactForm( @NotNull @NonNls String id ) {
    super( id, new CompoundPropertyModel( new FormData() ) );
    add( new TextField( "subject" ) );
    add( new TextArea( "text" ) );
    add( new TextField( "replyTo" ) );
  }

  @NotNull
  public FormData getFormData() {
    return ( FormData ) getModelObject();
  }

  /**
   * The form data
   */
  public static class FormData implements Serializable {
    @NotNull
    private String subject = "";
    @NotNull
    private String text = "";
    @NotNull
    @NonNls
    private String replyTo = "";

    @NotNull
    public String getSubject() {
      return subject;
    }

    public void setSubject( @NotNull String subject ) {
      this.subject = subject;
    }

    @NotNull
    public String getText() {
      return text;
    }

    public void setText( @NotNull String text ) {
      this.text = text;
    }

    @NotNull
    public String getReplyTo() {
      return replyTo;
    }

    public void setReplyTo( @NonNls @NotNull String replyTo ) {
      this.replyTo = replyTo;
    }
  }
}
