package eu.cedarsoft.wicket.breadcrumb;

import eu.cedarsoft.commons.struct.ChildNotFoundException;
import eu.cedarsoft.commons.struct.Node;
import eu.cedarsoft.commons.struct.Path;
import eu.cedarsoft.commons.struct.Route;
import org.apache.wicket.Page;
import org.jetbrains.annotations.NotNull;

import java.util.ArrayDeque;
import java.util.Queue;

/**
 *
 */
public class PageStructure {
  private Node rootNode;

  public PageStructure( @NotNull Node rootNode ) {
    this.rootNode = rootNode;
  }

  @NotNull
  public Node getRootNode() {
    return rootNode;
  }

  //todo cache results
  @NotNull
  public Node findNode( @NotNull Class<? extends Page> pageClass ) {
    Queue<Node> queue = new ArrayDeque<Node>();
    queue.add( rootNode );

    while ( !queue.isEmpty() ) {
      Node current = queue.poll();
      if ( pageClass.equals( current.getLookup().lookup( Class.class ) ) ) {
        return current;
      }
      queue.addAll( current.getChildren() );
    }
    throw new IllegalArgumentException( "No Node found for " + pageClass );
  }

  @NotNull
  public Route getRoute( @NotNull Path path ) throws ChildNotFoundException {
    return Route.buildRoute( getRootNode(), path );
  }

  @NotNull
  public Route findRoute( @NotNull Class<? extends Page> pageClass ) {
    return getRoute( findNode( pageClass ).getPath() );
  }
}
