package eu.cedarsoft.wicket.breadcrumb;

import eu.cedarsoft.commons.struct.Node;
import eu.cedarsoft.commons.struct.Path;
import eu.cedarsoft.commons.struct.Route;
import org.apache.wicket.Page;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.jetbrains.annotations.NotNull;

import java.util.Collections;
import java.util.Iterator;

/**
 *
 */
public class BreadCrumbElementProvider implements IDataProvider {
  private static final long serialVersionUID = 4683740027859662761L;

  private final PageStructureProvider pageStructureProvider;
  @NotNull
  private final IModel pathModel;
  @SuppressWarnings( {"TransientFieldNotInitialized"} )
  private transient Route route;

  public BreadCrumbElementProvider( @NotNull PageStructureProvider pageStructureProvider, @NotNull IModel /*Path */ pathModel ) {
    this.pageStructureProvider = pageStructureProvider;
    this.pathModel = pathModel;
  }

  @NotNull
  public Path getPath() {
    return ( Path ) pathModel.getObject();
  }

  @NotNull
  public synchronized Route getRoute() {
    if ( route == null ) {
      try {
        route = pageStructureProvider.getPageStructure().getRoute( getPath() );
      } catch ( Exception ignore ) {
        route = new Route( Collections.singletonList( pageStructureProvider.getPageStructure().getRootNode() ) );
      }
    }
    return route;
  }

  @NotNull
  public Iterator<?> iterator( int first, int count ) {
    return getRoute().getNodes().subList( first, first + count ).iterator();
  }

  public int size() {
    return getRoute().getNodes().size();
  }

  public IModel model( Object object ) {
    final Node node = ( Node ) object;
    //noinspection unchecked
    Class<? extends Page> pageClass = node.getLookup().lookup( Class.class );
    if ( pageClass == null ) {
      throw new IllegalStateException( "No page class found" );
    }
    return new Model( new BreadCrumbElement( node.getName(), pageClass ) );
  }

  public synchronized void detach() {
    this.route = null;
  }
}
