package eu.cedarsoft.wicket.breadcrumb;

import org.apache.wicket.Page;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

import java.io.Serializable;

/**
 *
 */
public class BreadCrumbElement implements Serializable {
  private static final long serialVersionUID = 105673105299057753L;

  @NotNull
  @NonNls
  private final String name;
  @NotNull
  private final Class<? extends Page> pageClass;

  public BreadCrumbElement( @NonNls @NotNull String name, @NotNull Class<? extends Page> pageClass ) {
    this.name = name;
    this.pageClass = pageClass;
  }

  @NotNull
  @NonNls
  public String getName() {
    return name;
  }

  @NotNull
  public Class<? extends Page> getPageClass() {
    return pageClass;
  }
}
