/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.smb1.com;

import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import jcifs.CIFSContext;
import jcifs.Configuration;
import jcifs.RuntimeCIFSException;
import jcifs.internal.smb1.AndXServerMessageBlock;
import jcifs.internal.smb1.ServerMessageBlock;
import jcifs.internal.smb1.com.ServerData;
import jcifs.internal.util.SMBUtil;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.NtlmPasswordAuthenticator;
import jcifs.util.Hexdump;

public class SmbComTreeConnectAndX
extends AndXServerMessageBlock {
    private boolean disconnectTid = false;
    private String service;
    private byte[] password;
    private int passwordLength;
    private CIFSContext ctx;
    private ServerData server;

    public SmbComTreeConnectAndX(CIFSContext ctx, ServerData server, String path, String service, ServerMessageBlock andx) {
        super(ctx.getConfig(), (byte)117, andx);
        this.ctx = ctx;
        this.server = server;
        this.path = path;
        this.service = service;
    }

    @Override
    protected int getBatchLimit(Configuration cfg, byte cmd) {
        int c = cmd & 0xFF;
        switch (c) {
            case 16: {
                return cfg.getBatchLimit("TreeConnectAndX.CheckDirectory");
            }
            case 0: {
                return cfg.getBatchLimit("TreeConnectAndX.CreateDirectory");
            }
            case 6: {
                return cfg.getBatchLimit("TreeConnectAndX.Delete");
            }
            case 1: {
                return cfg.getBatchLimit("TreeConnectAndX.DeleteDirectory");
            }
            case 45: {
                return cfg.getBatchLimit("TreeConnectAndX.OpenAndX");
            }
            case 7: {
                return cfg.getBatchLimit("TreeConnectAndX.Rename");
            }
            case 37: {
                return cfg.getBatchLimit("TreeConnectAndX.Transaction");
            }
            case 8: {
                return cfg.getBatchLimit("TreeConnectAndX.QueryInformation");
            }
        }
        return 0;
    }

    @Override
    protected int writeParameterWordsWireFormat(byte[] dst, int dstIndex) {
        if (this.server.security == 0 && this.ctx.getCredentials() instanceof NtlmPasswordAuthenticator) {
            NtlmPasswordAuthenticator pwAuth = (NtlmPasswordAuthenticator)this.ctx.getCredentials();
            if (SmbComTreeConnectAndX.isExternalAuth(pwAuth)) {
                this.passwordLength = 1;
            } else if (this.server.encryptedPasswords) {
                try {
                    this.password = pwAuth.getAnsiHash(this.ctx, this.server.encryptionKey);
                }
                catch (GeneralSecurityException e) {
                    throw new RuntimeCIFSException("Failed to encrypt password", e);
                }
                this.passwordLength = this.password.length;
            } else {
                if (this.ctx.getConfig().isDisablePlainTextPasswords()) {
                    throw new RuntimeCIFSException("Plain text passwords are disabled");
                }
                this.password = new byte[(pwAuth.getPassword().length() + 1) * 2];
                this.passwordLength = this.writeString(pwAuth.getPassword(), this.password, 0);
            }
        } else {
            this.passwordLength = 1;
        }
        dst[dstIndex++] = this.disconnectTid ? (byte)1 : 0;
        dst[dstIndex++] = 0;
        SMBUtil.writeInt2(this.passwordLength, dst, dstIndex);
        return 4;
    }

    private static boolean isExternalAuth(NtlmPasswordAuthenticator pwAuth) {
        return pwAuth instanceof NtlmPasswordAuthentication && !((NtlmPasswordAuthentication)pwAuth).areHashesExternal() && pwAuth.getPassword().isEmpty();
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        if (this.server.security == 0 && this.ctx.getCredentials() instanceof NtlmPasswordAuthenticator) {
            NtlmPasswordAuthenticator pwAuth = (NtlmPasswordAuthenticator)this.ctx.getCredentials();
            if (SmbComTreeConnectAndX.isExternalAuth(pwAuth)) {
                dst[dstIndex++] = 0;
            } else {
                System.arraycopy(this.password, 0, dst, dstIndex, this.passwordLength);
                dstIndex += this.passwordLength;
            }
        } else {
            dst[dstIndex++] = 0;
        }
        dstIndex += this.writeString(this.path, dst, dstIndex);
        try {
            System.arraycopy(this.service.getBytes("ASCII"), 0, dst, dstIndex, this.service.length());
        }
        catch (UnsupportedEncodingException uee) {
            return 0;
        }
        dstIndex += this.service.length();
        dst[dstIndex++] = 0;
        return dstIndex - start;
    }

    @Override
    protected int readParameterWordsWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    @Override
    public String toString() {
        String result = new String("SmbComTreeConnectAndX[" + super.toString() + ",disconnectTid=" + this.disconnectTid + ",passwordLength=" + this.passwordLength + ",password=" + Hexdump.toHexString(this.password, this.passwordLength, 0) + ",path=" + this.path + ",service=" + this.service + "]");
        return result;
    }
}

