/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.volley.swazzle.callback.com.android.volley;

import com.android.volley.Request;
import com.android.volley.VolleyError;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.HttpPathOverrideRequest;
import io.embrace.android.embracesdk.network.NetworkCaptureData;
import io.embrace.android.embracesdk.network.http.EmbraceHttpPathOverride;
import io.embrace.android.embracesdk.network.http.HttpMethod;
import io.embrace.android.volley.swazzle.callback.com.android.volley.utils.EmbraceVolleyUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;

public class NetworkDispatcher {
    private static Embrace embrace = Embrace.getInstance();

    public static void _preParseAndDeliverNetworkError(Request request, VolleyError error) {
        if (embrace.isStarted()) {
            String traceIdHeader = embrace.getTraceIdHeader();
            EmbraceVolleyNetworkErrorOverride networkOverride = new EmbraceVolleyNetworkErrorOverride(request);
            String url = EmbraceHttpPathOverride.getURLString((HttpPathOverrideRequest)networkOverride);
            NetworkCaptureData networkCaptureData = networkOverride.getNetworkCaptureData();
            String queryParams = networkOverride.getRequestQueryParams();
            if (networkCaptureData != null && queryParams != null && queryParams.length() > 0) {
                networkCaptureData.withRequestQueryParams(queryParams);
            }
            Embrace.getInstance().logNetworkClientError(url, EmbraceVolleyUtils.mapVolleyMethodToHttpMethod(request.getMethod()), System.currentTimeMillis() - error.getNetworkTimeMs(), System.currentTimeMillis(), error.getClass().getCanonicalName(), error.getMessage(), networkOverride.getHeaderByName(traceIdHeader), networkCaptureData);
        }
    }

    public static class EmbraceVolleyNetworkErrorOverride
    implements HttpPathOverrideRequest {
        private final Request request;
        private volatile String requestQueryParams;
        private volatile NetworkCaptureData networkCaptureData = null;

        EmbraceVolleyNetworkErrorOverride(Request request) {
            this.request = request;
            HttpMethod method = EmbraceVolleyUtils.mapVolleyMethodToHttpMethod(request.getMethod());
            if (method != null && embrace.shouldCaptureNetworkBody(request.getUrl(), method.name())) {
                byte[] responseBody;
                this.networkCaptureData = new NetworkCaptureData();
                try {
                    if (request.getHeaders() != null && !request.getHeaders().isEmpty()) {
                        this.networkCaptureData.withRequestHeaders(new HashMap(request.getHeaders()));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    byte[] requestBody = request.getBody();
                    if (requestBody.length > 102400) {
                        requestBody = Arrays.copyOf(requestBody, 102400);
                    }
                    this.networkCaptureData.withRequestBody(requestBody);
                }
                catch (Exception requestBody) {
                    // empty catch block
                }
                if (request.getCacheEntry() != null && (responseBody = request.getCacheEntry().data) != null && responseBody.length > 0) {
                    if (responseBody.length > 102400) {
                        responseBody = Arrays.copyOf(responseBody, 102400);
                    }
                    this.networkCaptureData.withResponseBody(responseBody);
                }
                if (request.getCacheEntry() != null && request.getCacheEntry().responseHeaders != null && !request.getCacheEntry().responseHeaders.isEmpty()) {
                    this.networkCaptureData.withResponseHeaders(new HashMap(request.getCacheEntry().responseHeaders));
                }
            }
        }

        public String getHeaderByName(String name) {
            try {
                return String.valueOf(this.request.getHeaders().get(name));
            }
            catch (Exception e) {
                return null;
            }
        }

        public String getOverriddenURL(String pathOverride) {
            try {
                URL url = new URL(this.request.getUrl());
                HttpMethod method = EmbraceVolleyUtils.mapVolleyMethodToHttpMethod(this.request.getMethod());
                this.requestQueryParams = method != null && embrace.shouldCaptureNetworkBody(this.request.getUrl(), method.name()) && url.getQuery() != null && !url.getQuery().isEmpty() ? url.getQuery() : null;
                return new URL(url.getProtocol(), url.getHost(), url.getPort(), pathOverride).toString();
            }
            catch (MalformedURLException e) {
                EmbraceLogger.logError((String)String.format(Locale.US, "Failed to override path of %s with %s", this.request.getUrl(), pathOverride));
                return this.request.getUrl();
            }
        }

        public String getURLString() {
            return this.request.getUrl();
        }

        public NetworkCaptureData getNetworkCaptureData() {
            return this.networkCaptureData;
        }

        public String getRequestQueryParams() {
            return this.requestQueryParams;
        }
    }
}

