/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.volley.swazzle.callback.com.android.volley;

import android.os.Handler;
import android.os.Looper;
import com.android.volley.Request;
import com.android.volley.Response;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.HttpPathOverrideRequest;
import io.embrace.android.embracesdk.network.NetworkCaptureData;
import io.embrace.android.embracesdk.network.http.EmbraceHttpPathOverride;
import io.embrace.android.embracesdk.network.http.HttpMethod;
import io.embrace.android.volley.swazzle.callback.com.android.volley.utils.EmbraceVolleyUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;

public class ExecutorDelivery {
    private static Embrace embrace = Embrace.getInstance();

    public static void _prePostResponse(Request<?> request, Response<?> response, Runnable runnable) {
        new Handler(Looper.getMainLooper()).post(() -> {
            if (embrace.isStarted()) {
                try {
                    String traceIdHeader = embrace.getTraceIdHeader();
                    EmbraceVolleyOverride volleyConnection = new EmbraceVolleyOverride(request, response);
                    String url = EmbraceHttpPathOverride.getURLString((HttpPathOverrideRequest)volleyConnection);
                    NetworkCaptureData networkCaptureData = volleyConnection.getNetworkCaptureData();
                    String queryParams = volleyConnection.getRequestQueryParams();
                    if (networkCaptureData != null && queryParams != null && queryParams.length() > 0) {
                        networkCaptureData.withRequestQueryParams(queryParams);
                    }
                    embrace.logNetworkCall(url, EmbraceVolleyUtils.mapVolleyMethodToHttpMethod(request.getMethod()), 200, response.cacheEntry != null ? System.currentTimeMillis() - response.cacheEntry.lastModified : System.currentTimeMillis(), System.currentTimeMillis(), volleyConnection.getRequestBodyLength(), volleyConnection.getResponseBodyLength(), traceIdHeader, networkCaptureData);
                }
                catch (Exception e) {
                    EmbraceLogger.logDebug((String)"Failed to create volley connection.", (Throwable)e);
                }
            }
        });
    }

    public static class EmbraceVolleyOverride
    implements HttpPathOverrideRequest {
        private static final int DEFAULT_STATUS_CODE = 200;
        private final Request request;
        private volatile String requestQueryParams;
        private NetworkCaptureData networkCaptureData;
        private long requestBodyLength;
        private long responseBodyLength;

        EmbraceVolleyOverride(Request<?> request, Response<?> response) {
            byte[] responseBody;
            byte[] requestBody;
            this.request = request;
            HttpMethod method = EmbraceVolleyUtils.mapVolleyMethodToHttpMethod(request.getMethod());
            try {
                requestBody = request.getBody();
                this.requestBodyLength = requestBody.length;
            }
            catch (Exception e) {
                requestBody = null;
                this.requestBodyLength = 0L;
            }
            if (response.cacheEntry != null && response.cacheEntry.data != null) {
                responseBody = response.cacheEntry.data;
                this.responseBodyLength = responseBody.length;
            } else {
                responseBody = null;
                this.responseBodyLength = 0L;
            }
            if (method != null && embrace.shouldCaptureNetworkBody(request.getUrl(), method.name())) {
                this.networkCaptureData = new NetworkCaptureData();
                try {
                    if (request.getHeaders() != null && !request.getHeaders().isEmpty()) {
                        this.networkCaptureData.withResponseHeaders(new HashMap(request.getHeaders()));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (requestBody != null && requestBody.length > 0) {
                    if (requestBody.length > 102400) {
                        requestBody = Arrays.copyOf(requestBody, 102400);
                    }
                    this.networkCaptureData.withRequestBody(requestBody);
                }
                if (responseBody != null && responseBody.length > 0) {
                    if (responseBody.length > 102400) {
                        responseBody = Arrays.copyOf(responseBody, 102400);
                    }
                    this.networkCaptureData.withResponseBody(responseBody);
                }
                if (response.cacheEntry != null && response.cacheEntry.responseHeaders != null && !response.cacheEntry.responseHeaders.isEmpty()) {
                    this.networkCaptureData.withResponseHeaders(new HashMap(response.cacheEntry.responseHeaders));
                }
            }
        }

        String getRequestQueryParams() {
            return this.requestQueryParams;
        }

        public String getHeaderByName(String name) {
            try {
                return String.valueOf(this.request.getHeaders().get(name));
            }
            catch (Exception e) {
                return null;
            }
        }

        public String getOverriddenURL(String pathOverride) {
            try {
                URL url = new URL(this.request.getUrl());
                this.requestQueryParams = url.getQuery() != null && !url.getQuery().isEmpty() ? url.getQuery() : null;
                return new URL(url.getProtocol(), url.getHost(), url.getPort(), pathOverride).toString();
            }
            catch (MalformedURLException e) {
                EmbraceLogger.logError((String)String.format(Locale.US, "Failed to override path of %s with %s", this.request.getUrl(), pathOverride));
                return this.request.getUrl();
            }
        }

        public String getURLString() {
            return this.request.getUrl();
        }

        long getRequestBodyLength() {
            return this.requestBodyLength;
        }

        long getResponseBodyLength() {
            return this.responseBodyLength;
        }

        NetworkCaptureData getNetworkCaptureData() {
            return this.networkCaptureData;
        }
    }
}

