/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.volley.swazzle.callback.com.android.volley;

import com.android.volley.Request;
import com.android.volley.VolleyError;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.HttpPathOverrideRequest;
import io.embrace.android.embracesdk.network.http.EmbraceHttpPathOverride;
import io.embrace.android.embracesdk.network.http.HttpMethod;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;

public class NetworkDispatcher {
    private static Embrace embrace = Embrace.getInstance();

    public static void _preParseAndDeliverNetworkError(Request request, VolleyError error) {
        if (embrace.isStarted()) {
            String url = EmbraceHttpPathOverride.getURLString((HttpPathOverrideRequest)new EmbraceVolleyOverride(request));
            Embrace.getInstance().logNetworkClientError(url, NetworkDispatcher.mapVolleyMethodToHttpMethod(request.getMethod()), System.currentTimeMillis() - error.getNetworkTimeMs(), System.currentTimeMillis(), error.getClass().getCanonicalName(), error.getMessage());
        }
    }

    private static HttpMethod mapVolleyMethodToHttpMethod(int method) {
        switch (method) {
            case 0: {
                return HttpMethod.GET;
            }
            case 1: {
                return HttpMethod.POST;
            }
            case 2: {
                return HttpMethod.PUT;
            }
            case 3: {
                return HttpMethod.DELETE;
            }
            case 4: {
                return HttpMethod.HEAD;
            }
            case 5: {
                return HttpMethod.OPTIONS;
            }
            case 6: {
                return HttpMethod.TRACE;
            }
            case 7: {
                return HttpMethod.PATCH;
            }
        }
        return null;
    }

    public static class EmbraceVolleyOverride
    implements HttpPathOverrideRequest {
        private final Request request;

        EmbraceVolleyOverride(Request request) {
            this.request = request;
        }

        public String getHeaderByName(String name) {
            try {
                return this.request.getHeaders().get(name).toString();
            }
            catch (Exception e) {
                return null;
            }
        }

        public String getOverriddenURL(String pathOverride) {
            try {
                URL url = new URL(this.request.getUrl());
                return new URL(url.getProtocol(), url.getHost(), url.getPort(), pathOverride).toString();
            }
            catch (MalformedURLException e) {
                EmbraceLogger.logError((String)String.format(Locale.US, "Failed to override path of %s with %s", this.request.getUrl(), pathOverride));
                return this.request.getUrl();
            }
        }

        public String getURLString() {
            return this.request.getUrl();
        }
    }
}

