package io.embrace.android.embracesdk;

import com.google.gson.annotations.SerializedName;

import java.util.List;

/**
 * Represents performance info for an {@link Event}. This had to be sub-classed, as the API requires
 * the same key, 'nr', be used to represent two completely different objects. In order to overload
 * this key, we need two implementations of the {@link PerformanceInfo}.
 * <p>
 * For an {@link Event} this contains a list of network calls.
 */
final class EventPerformanceInfo extends PerformanceInfo {

    @SerializedName("nr")
    private final List<NetworkCallV2> networkCalls;

    private EventPerformanceInfo(Builder builder) {
        super(builder);
        this.networkCalls = builder.networkCalls;
    }

    public static Builder newBuilder() {
        return new EventPerformanceInfo.Builder();
    }


    static class Builder extends PerformanceInfo.Builder {
        private List<NetworkCallV2> networkCalls;

        private Builder() {
        }


        public Builder withNetworkCalls(List<NetworkCallV2> networkCalls) {
            this.networkCalls = networkCalls;
            return this;
        }


        public EventPerformanceInfo build() {
            return new EventPerformanceInfo(this);
        }
    }
}
