/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import io.embrace.android.embracesdk.EmbraceLogger;
import java.nio.charset.Charset;

final class EmbraceNetworkUtils {
    private static final int TRACE_ID_MAXIMUM_ALLOWED_LENGTH = 64;

    EmbraceNetworkUtils() {
    }

    static String getValidTraceId(String traceId) {
        if (traceId == null) {
            EmbraceLogger.logDebug("Ignoring null traceId");
            return null;
        }
        if (!Charset.forName("US-ASCII").newEncoder().canEncode(traceId)) {
            EmbraceLogger.logDebug(String.format("Relative path must not contain unicode characters. Relative path %s will be ignored.", traceId));
            return null;
        }
        if (traceId.length() > 64) {
            EmbraceLogger.logWarning(String.format("Truncating traceId to %s characters", traceId));
            traceId = traceId.substring(0, 64);
        }
        return traceId;
    }
}

