package io.embrace.android.embracesdk;

import com.fernandocejas.arrow.optional.Optional;
import com.google.gson.annotations.SerializedName;

/**
 * Breadcrumb that represents the display event for a View.
 */
final class ViewBreadcrumb implements Breadcrumb {

    private static final String FALLBACK_SCREEN_NAME = "Unknown screen";

    /**
     * The screen name for the view breadcrumb.
     */
    @SerializedName("vn")
    private final String screen;

    /**
     * The timestamp at which the event occurred.
     */
    @SerializedName("ts")
    private final Long timestamp;

    ViewBreadcrumb(String screen, long timestamp) {
        this.timestamp = timestamp;
        this.screen = screen != null ? screen : FALLBACK_SCREEN_NAME;
    }

    Optional<String> getScreen() {
        return Optional.of(screen);
    }

    @Override
    public long getTimestamp() {
        return timestamp;
    }
}
