package io.embrace.android.embracesdk;

import java.util.Locale;
import java.util.UUID;

public final class Uuid {
  private Uuid() {
  }

  public static String getEmbUuid() {
    return getEmbUuid(UUID.randomUUID().toString());
  }

  public static String getEmbUuid(String uuid) {
    return String.format("%32.32s", uuid.replaceAll("-", "")).replace(' ', '0')
        .toUpperCase(Locale.getDefault());
  }
}
