package io.embrace.android.embracesdk;

import com.google.gson.annotations.SerializedName;

class NetworkCallV2 {
    /** The number of bytes received during the network request. */
    @SerializedName("bi")
    private final long bytesReceived;

    /** The number of bytes sent during the network request. */
    @SerializedName("bo")
    private final long bytesSent;

    /** The duration of the network request. */
    @SerializedName("dur")
    private final long duration;

    /** If an exception was thrown, the name of the class which caused the exception. */
    @SerializedName("ed")
    private final String errorType;

    /** The end time of the request. */
    @SerializedName("et")
    private final long endTime;

    /** The HTTP response code. */
    @SerializedName("rc")
    private final int responseCode;

    /** The URL being requested. */
    @SerializedName("url")
    private final String url;

    /** The start time of the request. */
    @SerializedName("st")
    private final long startTime;

    /** The HTTP method the network request corresponds to. */
    @SerializedName("x")
    private final String httpMethod;

    /** The trace ID that can be used to trace a particular request. */
    @SerializedName("t")
    private final String traceId;

    private NetworkCallV2(Builder builder) {
        bytesReceived = builder.bytesReceived;
        bytesSent = builder.bytesSent;
        duration = builder.duration;
        errorType = builder.errorType;
        endTime = builder.endTime;
        responseCode = builder.responseCode;
        url = builder.url;
        startTime = builder.startTime;
        httpMethod = builder.httpMethod;
        traceId = builder.traceId;
    }

    public long getBytesReceived() {
        return bytesReceived;
    }

    public long getBytesSent() {
        return bytesSent;
    }

    public long getDuration() {
        return duration;
    }

    public String getErrorType() {
        return errorType;
    }

    public long getEndTime() {
        return endTime;
    }

    public int getResponseCode() {
        return responseCode;
    }

    public String getUrl() {
        return url;
    }

    public long getStartTime() {
        return startTime;
    }

    public String getHttpMethod() {
        return httpMethod;
    }

    public String getTraceId() {
        return traceId;
    }

    static Builder newBuilder() {
        return new Builder();
    }


    static final class Builder {
        private long bytesReceived;
        private long bytesSent;
        private long duration;
        private String errorType;
        private long endTime;
        private int responseCode;
        private String url;
        private long startTime;
        private String httpMethod;
        private String traceId;

        private Builder() {
        }

        Builder withBytesReceived(long bytesReceived) {
            this.bytesReceived = bytesReceived;
            return this;
        }

        Builder withBytesSent(long bytesSent) {
            this.bytesSent = bytesSent;
            return this;
        }

        Builder withDuration(long duration) {
            this.duration = duration;
            return this;
        }

        Builder withErrorType(String errorType) {
            this.errorType = errorType;
            return this;
        }

        Builder withEndTime(long endTime) {
            this.endTime = endTime;
            return this;
        }

        Builder withResponseCode(int responseCode) {
            this.responseCode = responseCode;
            return this;
        }

        Builder withUrl(String url) {
            this.url = url;
            return this;
        }

        Builder withStartTime(long startTime) {
            this.startTime = startTime;
            return this;
        }

        Builder withHttpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        Builder withTraceId(String traceId){
            this.traceId = traceId;
            return this;
        }

        NetworkCallV2 build() {
            return new NetworkCallV2(this);
        }
    }
}
