package io.embrace.android.embracesdk;

import java.io.Closeable;
import java.util.List;

/**
 * Provides information on the state of the CPU on the device.
 */
interface CpuService extends Closeable {

    /**
     * Gets a list of intervals during which the CPU was critically high during the specified period.
     *
     * @param startTime the starting timestamp of the period
     * @param endTime the ending timestamp of the period
     * @return the list of CPU critical intervals within the specified period
     */
    List<Interval> getCpuCriticalIntervals(long startTime, long endTime);

}
