package io.embrace.android.embracesdk;

import com.google.gson.annotations.SerializedName;

/**
 * A measurement of the device's battery level at a given point in time.
 */
final class BatteryMeasurement {
    /** The timestamp at which the battery measurement event occurred. */
    @SerializedName("ts")
    private final long timestamp;

    /** The power level of the device at the time the battery measurement event occurred. */
    @SerializedName("v")
    private final float value;

    BatteryMeasurement(long timestamp, float value) {
        this.timestamp = timestamp;
        this.value = value;
    }

    long getTimestamp() {
        return timestamp;
    }

    float getValue() {
        return value;
    }
}
