/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.content.Context;
import android.telephony.SignalStrength;
import android.telephony.TelephonyManager;
import java.lang.reflect.Method;

class SignalStrengthUtils {
    static final int SIGNAL_STRENGTH_NONE_OR_UNKNOWN = 0;
    static final int SIGNAL_STRENGTH_POOR = 1;
    static final int SIGNAL_STRENGTH_MODERATE = 2;
    static final int SIGNAL_STRENGTH_GOOD = 3;
    static final int SIGNAL_STRENGTH_GREAT = 4;
    private final TelephonyManager mTelephonyManager;

    SignalStrengthUtils(Context context) {
        this.mTelephonyManager = (TelephonyManager)context.getSystemService("phone");
    }

    int getLevel(SignalStrength signalStrength) {
        try {
            int lteLevel = this.getLteLevel(signalStrength);
            if (lteLevel != 0) {
                return lteLevel;
            }
            int evdoLevel = this.getEvdoLevel(signalStrength);
            if (evdoLevel != 0) {
                return evdoLevel;
            }
            return 1;
        }
        catch (Throwable ex) {
            return 0;
        }
    }

    private int getEvdoLevel(SignalStrength signalStrength) {
        int evdoDbm = signalStrength.getEvdoDbm();
        int evdoSnr = signalStrength.getEvdoSnr();
        int levelEvdoDbm = evdoDbm >= -65 ? 4 : (evdoDbm >= -75 ? 3 : (evdoDbm >= -90 ? 2 : (evdoDbm >= -105 ? 1 : 0)));
        int levelEvdoSnr = evdoSnr >= 7 ? 4 : (evdoSnr >= 5 ? 3 : (evdoSnr >= 3 ? 2 : (evdoSnr >= 1 ? 1 : 0)));
        int level = levelEvdoDbm < levelEvdoSnr ? levelEvdoDbm : levelEvdoSnr;
        return level;
    }

    private int getLteLevel(SignalStrength signalStrength) {
        if (this.mTelephonyManager.getNetworkType() != 13) {
            return 0;
        }
        try {
            Method methodGetLteLevel = SignalStrength.class.getMethod("getLteLevel", new Class[0]);
            return (Integer)methodGetLteLevel.invoke((Object)signalStrength, new Object[0]);
        }
        catch (Throwable t) {
            return 0;
        }
    }
}

