/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import com.google.gson.annotations.SerializedName;
import io.embrace.android.embracesdk.AnrInterval;
import io.embrace.android.embracesdk.BatteryMeasurement;
import io.embrace.android.embracesdk.ConnectionQualityInterval;
import io.embrace.android.embracesdk.DiskUsage;
import io.embrace.android.embracesdk.Interval;
import io.embrace.android.embracesdk.MemorySample;
import io.embrace.android.embracesdk.MemoryWarning;
import io.embrace.android.embracesdk.SignalStrength;
import java.util.List;

abstract class PerformanceInfo {
    @SerializedName(value="bt")
    private final float batteryLevel;
    @SerializedName(value="ds")
    private final DiskUsage diskUsage;
    @SerializedName(value="me")
    private final List<MemorySample> memorySamples;
    @SerializedName(value="mw")
    private final List<MemoryWarning> memoryWarnings;
    @SerializedName(value="bc")
    private final List<Interval> chargingIntervals;
    @SerializedName(value="cp")
    private final List<Interval> criticalCpuIntervals;
    @SerializedName(value="ns")
    private final List<Interval> networkInterfaceIntervals;
    @SerializedName(value="bm")
    private final List<BatteryMeasurement> batteryMeasurements;
    @SerializedName(value="anr")
    private final List<AnrInterval> anrIntervals;
    @SerializedName(value="ss")
    private final List<SignalStrength> signalStrength;
    @SerializedName(value="cq")
    private final List<ConnectionQualityInterval> connectionQualityIntervals;

    protected PerformanceInfo(Builder builder) {
        this.batteryLevel = builder.batteryLevel;
        this.diskUsage = builder.diskUsage;
        this.memorySamples = builder.memorySamples;
        this.memoryWarnings = builder.memoryWarnings;
        this.chargingIntervals = builder.chargingIntervals;
        this.criticalCpuIntervals = builder.criticalCpuIntervals;
        this.networkInterfaceIntervals = builder.networkInterfaceIntervals;
        this.batteryMeasurements = builder.batteryMeasurements;
        this.anrIntervals = builder.anrIntervals;
        this.signalStrength = builder.signalStrength;
        this.connectionQualityIntervals = builder.connectionQualityIntervals;
    }

    static abstract class Builder {
        private float batteryLevel;
        private DiskUsage diskUsage;
        private List<MemorySample> memorySamples;
        private List<MemoryWarning> memoryWarnings;
        private List<Interval> chargingIntervals;
        private List<Interval> criticalCpuIntervals;
        private List<Interval> networkInterfaceIntervals;
        private List<BatteryMeasurement> batteryMeasurements;
        private List<AnrInterval> anrIntervals;
        private List<SignalStrength> signalStrength;
        private List<ConnectionQualityInterval> connectionQualityIntervals;

        protected Builder() {
        }

        public Builder withBatteryLevel(float batteryLevel) {
            this.batteryLevel = batteryLevel;
            return this;
        }

        public Builder withDiskUsage(DiskUsage diskUsage) {
            this.diskUsage = diskUsage;
            return this;
        }

        public Builder withMemorySamples(List<MemorySample> memorySamples) {
            this.memorySamples = memorySamples;
            return this;
        }

        public Builder withMemoryWarnings(List<MemoryWarning> memoryWarnings) {
            this.memoryWarnings = memoryWarnings;
            return this;
        }

        public Builder withChargingIntervals(List<Interval> chargingIntervals) {
            this.chargingIntervals = chargingIntervals;
            return this;
        }

        public Builder withCriticalCpuIntervals(List<Interval> criticalCpuIntervals) {
            this.criticalCpuIntervals = criticalCpuIntervals;
            return this;
        }

        public Builder withNetworkInterfaceIntervals(List<Interval> networkInterfaceIntervals) {
            this.networkInterfaceIntervals = networkInterfaceIntervals;
            return this;
        }

        public Builder withBatteryMeasurements(List<BatteryMeasurement> batteryMeasurements) {
            this.batteryMeasurements = batteryMeasurements;
            return this;
        }

        public Builder withAnrIntervals(List<AnrInterval> anrIntervals) {
            this.anrIntervals = anrIntervals;
            return this;
        }

        public Builder withSignalStrength(List<SignalStrength> signalStrength) {
            this.signalStrength = signalStrength;
            return this;
        }

        public Builder withConnectionQualityIntervals(List<ConnectionQualityInterval> connectionQualityIntervals) {
            this.connectionQualityIntervals = connectionQualityIntervals;
            return this;
        }
    }
}

