/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import com.google.gson.annotations.SerializedName;
import io.embrace.android.embracesdk.NetworkCallV2;
import java.util.List;
import java.util.Map;

class NetworkSessionV2 {
    @SerializedName(value="r")
    private final List<NetworkCallV2> requests;
    @SerializedName(value="c")
    private final Map<String, DomainCount> requestCounts;

    NetworkSessionV2(List<NetworkCallV2> requests, Map<String, DomainCount> requestCounts) {
        this.requests = requests;
        this.requestCounts = requestCounts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkSessionV2 that = (NetworkSessionV2)o;
        if (this.requests != null ? !this.requests.equals(that.requests) : that.requests != null) {
            return false;
        }
        return this.requestCounts != null ? this.requestCounts.equals(that.requestCounts) : that.requestCounts == null;
    }

    public int hashCode() {
        int result = this.requests != null ? this.requests.hashCode() : 0;
        result = 31 * result + (this.requestCounts != null ? this.requestCounts.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "NetworkSessionV2{requests=" + this.requests + ", requestCounts=" + this.requestCounts + '}';
    }

    static class DomainCount {
        private final int requestCount;
        private final int captureLimit;

        DomainCount(int requestCount, int captureLimit) {
            this.requestCount = requestCount;
            this.captureLimit = captureLimit;
        }

        public int getRequestCount() {
            return this.requestCount;
        }

        public int getCaptureLimit() {
            return this.captureLimit;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DomainCount that = (DomainCount)o;
            if (this.requestCount != that.requestCount) {
                return false;
            }
            return this.captureLimit == that.captureLimit;
        }

        public int hashCode() {
            int result = this.requestCount;
            result = 31 * result + this.captureLimit;
            return result;
        }

        public String toString() {
            return "DomainCount{requestCount=" + this.requestCount + ", captureLimit=" + this.captureLimit + '}';
        }
    }
}

