/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.annotation.TargetApi;
import android.app.usage.StorageStats;
import android.app.usage.StorageStatsManager;
import android.content.ContentResolver;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Process;
import android.os.StatFs;
import android.os.SystemClock;
import android.os.storage.StorageManager;
import android.provider.Settings;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.fernandocejas.arrow.optional.Optional;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.Uuid;
import java.io.File;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java9.util.Lists;
import java9.util.stream.StreamSupport;

final class MetadataUtils {
    private static final String OS_VERSION = "Android OS";
    private static final String ENVIRONMENT_DEV = "dev";
    private static final String ENVIRONMENT_PROD = "prod";
    private static final List<String> JAILBREAK_LOCATIONS = Lists.of((Object)"/sbin/", (Object)"/system/bin/", (Object)"/system/xbin/", (Object)"/data/local/xbin/", (Object)"/data/local/bin/", (Object)"/system/sd/xbin/", (Object)"/system/bin/failsafe/", (Object)"/data/local/");

    static String getDeviceManufacturer() {
        return Build.MANUFACTURER;
    }

    static String getModel() {
        return Build.MODEL;
    }

    static String getArchitecture() {
        return Build.VERSION.SDK_INT >= 21 ? Build.SUPPORTED_ABIS[0] : Build.CPU_ABI;
    }

    static String getLocale() {
        return Locale.getDefault().getLanguage() + "_" + Locale.getDefault().getCountry();
    }

    static String getOperatingSystemType() {
        return OS_VERSION;
    }

    static String getOperatingSystemVersion() {
        return String.valueOf(Build.VERSION.RELEASE);
    }

    static int getOperatingSystemVersionCode() {
        return Build.VERSION.SDK_INT;
    }

    static String getOperatingSystemVersionForRequest() {
        return String.format(Locale.US, "%d.0.0", Build.VERSION.SDK_INT);
    }

    static Long getSystemUptime() {
        return SystemClock.uptimeMillis();
    }

    static Optional<String> getScreenResolution(WindowManager windowManager) {
        try {
            Display display = windowManager.getDefaultDisplay();
            DisplayMetrics displayMetrics = new DisplayMetrics();
            display.getMetrics(displayMetrics);
            return Optional.of((Object)String.format(Locale.US, "%dx%d", displayMetrics.widthPixels, displayMetrics.heightPixels));
        }
        catch (Exception ex) {
            EmbraceLogger.logDebug("Could not determine screen resolution", ex);
            return Optional.absent();
        }
    }

    static String getTimezoneId() {
        return TimeZone.getDefault().getID();
    }

    static long getInternalStorageTotalCapacity(StatFs statFs) {
        if (Build.VERSION.SDK_INT >= 18) {
            return statFs.getTotalBytes();
        }
        return (long)statFs.getBlockCount() * (long)statFs.getBlockSize();
    }

    static long getInternalStorageFreeCapacity(StatFs statFs) {
        if (Build.VERSION.SDK_INT >= 18) {
            return statFs.getFreeBytes();
        }
        return (long)statFs.getFreeBlocks() * (long)statFs.getBlockSize();
    }

    @TargetApi(value=26)
    static Optional<Long> getDeviceDiskAppUsage(StorageStatsManager storageStatsManager, PackageManager packageManager, String contextPackageName) {
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(contextPackageName, 0);
            if (packageInfo != null && packageInfo.packageName != null) {
                StorageStats stats = storageStatsManager.queryStatsForPackage(StorageManager.UUID_DEFAULT, packageInfo.packageName, Process.myUserHandle());
                return Optional.of((Object)(stats.getAppBytes() + stats.getDataBytes() + stats.getCacheBytes()));
            }
        }
        catch (Exception ex) {
            EmbraceLogger.logDebug("Error retrieving device disk usage", ex);
        }
        return Optional.absent();
    }

    static boolean isJailbroken() {
        if (MetadataUtils.isEmulator()) {
            return false;
        }
        return StreamSupport.stream(JAILBREAK_LOCATIONS).anyMatch(path -> new File(path + "su").exists());
    }

    static boolean isEmulator() {
        return Build.FINGERPRINT.startsWith("generic") || Build.FINGERPRINT.startsWith("unknown") || Build.MODEL.contains("google_sdk") || Build.MODEL.contains("Emulator") || Build.MODEL.contains("Android SDK built for x86") || Build.MANUFACTURER.contains("Genymotion") || Build.BRAND.startsWith("generic") && Build.DEVICE.startsWith("generic") || "google_sdk".equals(Build.PRODUCT);
    }

    static Optional<String> getVersionCodeForRequest(PackageManager packageManager, String packageName) {
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(packageName, 0);
            String result = String.format(Locale.US, "%d.0.0", packageInfo.versionCode);
            return Optional.of((Object)result);
        }
        catch (Exception ex) {
            EmbraceLogger.logDebug("Error retrieving version information from the package", ex);
            return Optional.absent();
        }
    }

    static String createDeviceId(ContentResolver contentResolver) {
        String secureId = Settings.Secure.getString((ContentResolver)contentResolver, (String)"android_id");
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        if (messageDigest != null && secureId != null) {
            messageDigest.update(secureId.getBytes(), 0, secureId.length());
            return Uuid.getEmbUuid(new BigInteger(1, messageDigest.digest()).toString(16));
        }
        return secureId != null ? Uuid.getEmbUuid(secureId) : secureId;
    }

    static boolean isDebug(ApplicationInfo applicationInfo) {
        return (applicationInfo.flags & 2) != 0;
    }

    static String appEnvironment(ApplicationInfo applicationInfo) {
        return MetadataUtils.isDebug(applicationInfo) ? ENVIRONMENT_DEV : ENVIRONMENT_PROD;
    }

    private MetadataUtils() {
    }
}

